<?php

use App\Fun\Fun;
use App\Model\Accounting\AccountChartModel;
use App\Model\Accounting\JournalModel;
use App\Model\CurrencyModel;
use App\Model\CustomerModel;
use App\Model\Hr\HrBranch;
use App\Model\location\CommuneModel;
use App\Model\location\DistrictModel;
use App\Model\product\BrandModel;
use App\Model\product\CategoryModel;
use App\Model\product\ShelfModel;
use App\Model\product\UnitModel;
use App\Model\ProductModel;
use App\Model\location\ProvinceModel;
use App\Model\ProductUnitModel;
use App\Model\purchase_order\PurchaseOrderModel;
use App\Model\PurchaseModel;
use App\Model\SaleDetailsModel;
use App\Model\SaleModel;
use App\Model\setup\MemberTypeModel;
use App\Model\setup\ReasonModel;
use App\Model\StockModel;
use App\Model\SupplierModel;
use App\Models\TypeOfIllness;
use App\Model\InvoiceNumberModel;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

function if_kh()
{
    return (app()->getLocale() == 'km');
}

function findCustomer($id)
{
    return CustomerModel::find($id);
}

function findBranch($id)
{
    return HrBranch::find($id);
}

function FindBranchID()
{
    return \Auth::user()->branch_id;
}

function myBranch()
{
    return HrBranch::find(FindBranchID());
}

function mainBranch()
{
    return HrBranch::orderBy('main', 'DESC')->first();;
}

function findImg($img)
{
    $file = asset($img);
    if (file_exists($img)) {
        return $file;
    }
    return asset('images/default.png');
}

function getProductById($id)
{
    return ProductModel::find($id);
}

function getSaleDetail($sale_id)
{
    return SaleDetailsModel::where('sale_id', $sale_id)->get();
}

function findSale($sale_id)
{
    return SaleModel::find($sale_id);
}

function findUnit($id)
{
    return UnitModel::find($id);
}

function findCurrency($id)
{
    return CurrencyModel::find($id);
}

function findPurchase($purchase_id)
{
    return PurchaseModel::find($purchase_id);
}

function findUser($id)
{
    return User::find($id);
}

function getPaymentStatus($key = '', $no_bg = '')
{
    $status = ['due' => __('administrator.due'), 'partial' => __('administrator.partial'), 'paid' => __('administrator.paid')];
    if ($key || $no_bg) {
        if ($no_bg) {
            return $status[$key] ?? '';
        } else {
            $color = ['paid' => 'success', 'due' => 'danger', 'partial' => 'info'];
            return '<span class="label label-' . ($color[$key] ?? 'default') . '">' . ($status[$key] ?? '') . '</span>';
        }
    }
    return $status;
}

function getSupplier()
{
    return SupplierModel::pluck('name', 'id');
}

function findSupplier($id)
{
    return SupplierModel::find($id);
}

function nsoLogo()
{
    return asset(mainBranch()->logo);
}

function getAllSomeUser($if_normal_user_put_something = '')
{
    $id = Auth::user()->id;
    $all = User::where(function ($q) use ($if_normal_user_put_something, $id) {
        if ($if_normal_user_put_something) {
            $q->where('id', $id);
        }
    })
        ->where('status', 1)
        ->pluck('name', 'id');
    return $all;
}

function checkRequestStatus($status)
{
    $status_ = '';
    Fun::lang();
    if (($status) == 2) {
        $status_ = '<span class="label label-warning">' . __('administrator.pending') . '</span>';
    }
    if (($status) == 1) {
        $status_ = '<span class="label label-success">' . __('administrator.approve') . '</span>';
    }
    if (($status) == 3) {
        $status_ = '<span class="label label-danger">' . __('administrator.reject') . '</span>';
    }
    return $status_;
}

function textStatus($status)
{
    $label = 'primary';
    Fun::lang();
    if ($status == 'pending') {
        $label = 'warning';
    }
    if ($status === 'processing' || $status === 'partial') {
        $label = 'info';
    }
    if ($status === 'receive' || $status === 'approved' || $status === 'received' || $status === 'paid') {
        $label = 'success';
    }
    if ($status === 'reject' || $status === 'rejected' || $status === 'owe' || $status === 'due') {
        $label = 'danger';
    }
    if ($status)
        return '<span class="label label-' . $label . '">' . __('administrator.' . $status) . '</span>';
}

function checkPaymentStatus($payment_status)
{
    Fun::lang();
    $status = '';
    if (strtolower($payment_status) == 'due') {
        $status = '<span class="label label-danger">' . __('administrator.due') . '</span>';
    }
    if (strtolower($payment_status) == 'partial') {
        $status = '<span class="label label-warning">' . __('administrator.partial') . '</span>';
    }
    if (strtolower($payment_status) == 'paid') {
        $status = '<span class="label label-success">' . __('administrator.paid') . '</span>';
    }
    return $status;
}

function getUnit()
{
    return UnitModel::pluck('unit', 'id');
}

function getCategory($key = null)
{
    $category = CategoryModel::where(
        function ($q) use ($key) {
            if ($key) {
                $q->where('id', $key);
            }
        }
    )->pluck('category_name', 'id');
    if ($key) {
        return $category[$key];
    }
    return $category;
}

function getBrand()
{
    return BrandModel::where('status', 1)->where('branch_id', FindBranchID());
}

function findBrand($brand_id)
{
    return BrandModel::find($brand_id);
}

function branchMenu()
{
    return 'layouts.master';
}

function currency()
{
    return [
        '1' => '៛',
        '2' => '$'
    ];
}

function getProductBrand()
{
    return BrandModel::where('status', 1)->pluck('brand', 'id');
}

function getProductShelf()
{
    return \DB::table('nso007_shelf')->where('member_id', null)->pluck('name', 'id');
}

function getDataRecord()
{
    $jsonString = file_get_contents(base_path('resources/views/administrator/setting/data.json'));
    return json_decode($jsonString, true);
}

function currencyExchange()
{
    return floatval(getDataRecord()[0]['value']);
}

function getUsers($noAuth = '', $type = 'admin')
{
    return User::where(function ($q) use ($noAuth) {
        if ($noAuth) {
            $q->where('id', '!=', Auth::user()->id);
        }
    })
        ->where(function ($q) use ($type) {
            if ($type) {
                $q->where('user_type', $type);
            }
        })
        ->where(function ($q)  {
            if (Auth::user()->user_type=='member') {
                $q->where('leader_id', Auth::id());
            }
        })
        ->pluck('name', 'id');
}

function getMemberTypes($id = null)
{
    if ($id) {
        return MemberTypeModel::find($id)->name ?? '';
    }
    return MemberTypeModel::where(function ($q) {
        if (ifMember()) {
            $user_level = MemberTypeModel::find(Auth::user()->member_type_id)->level ?? 0;
            $q->where('level', '>', $user_level);
        }
    })
        ->selectRaw('CONCAT(name," [",discount,"%]") as text,id')
        ->pluck('text', 'id');
}

function adjStockAdmin($branch, $shelf, $product_unit, $qty, $exp_date = null) //  add +|- before qty
{
    $where = ['branch_id' => $branch, 'shelf' => $shelf, 'product_unit_id' => $product_unit, 'type' => 'admin'];
    $data = $where;
    $product_unit = ProductUnitModel::find($product_unit);
    $qty *= $product_unit->qty_per_unit;
    if ($exp_date) {
        $data['expire_date'] = $exp_date;
    }
    $data['stock_qty'] = DB::raw('IF(stock_qty>0,stock_qty,0)+' . $qty);
    $data['item_code'] = $product_unit->item_code;
    $data['product_id'] = $product_unit->product_id;
    StockModel::UpdateOrCreate($where,
        $data);
    return 'ok';
}

function adjStockMember($member_id, $product_unit, $qty) //  add +|- before qty
{
    $where = ['member_id' => $member_id, 'product_unit_id' => $product_unit, 'type' => 'member'];
    $data = $where;
    $product_unit = ProductUnitModel::find($product_unit);
    $qty *= $product_unit->qty_per_unit;
    $data['stock_qty'] = DB::raw('IF(stock_qty>0,stock_qty,0)+' . $qty);
    $data['product_id'] = $product_unit->product_id;
    $data['item_code'] = $product_unit->item_code;
    StockModel::UpdateOrCreate($where,
        $data);
    return 'ok';
}

function know_product_from()
{
    return \DB::table('nso007_crm_lead_source')->where('type', 'known_from')->pluck('source_name', 'id');
}

function leadSource($key = '')
{
    $data = \DB::table('nso007_crm_lead_source')->pluck('source_name', 'id');
    if ($key) {
        return $data[$key];
    }
    return $data;
}

function contact_by()
{
    return \DB::table('nso007_crm_lead_source')->where('type', 'contact')->pluck('source_name', 'id');
}

function illness_type()
{
    return TypeOfIllness::whereNull('deleted_at')->pluck(if_kh() ? 'name_km' : 'name_en', 'id');
}

function Findillness($id)
{
    return TypeOfIllness::find($id);
}

function getOutCome()
{
    return [
        'Interest' => 'Interest',
        'Not Interest' => 'Not Interest',
        'Not Response' => 'Not Response',
        'Requested more Information' => 'Requested more Information',
        'Next Time' => 'Next Time',
    ];
}

function refNumber($branch, $type = 'ref', $pre = '')
{
    $inv = DB::table('nso007_invoice_number')->where([
        'member_id' => $branch,
        'type' => $type,
        'year' => date('Y')
    ])->first();
    if ($inv) {
        $number = (int)$inv->increase + 1;
    } else {
        $number = 1;
    }
    $invoice = ($pre ?: mainBranch()->prefix) . Auth::id() . sprintf('%05d', $number);
    InvoiceNumberModel::updateOrCreate([
        'member_id' => $branch,
        'type' => $type,
        'year' => date('Y')
    ], [
        'member_id' => $branch,
        'type' => $type,
        'year' => date('Y'),
        'increase' => $number
    ]);
    return $invoice;
}

function invNumber($branch)
{ // count
    $mybranch = findBranch($branch);
    $sale = SaleModel::where(['branch_id' => $branch, 'year' => date('Y')])->count();
    $po = PurchaseOrderModel::where(['request_to' => $branch, 'year' => date('Y')])->where('status', '!=', 1)->count();
    return ($mybranch->prefix) . '-20210701' . sprintf('%05d', (($sale + $po) + 1));
}

function getProvince()
{
    return ProvinceModel::pluck('name_kh', 'id')->prepend('Please select','');
}

function findProvince($id)
{
    return ProvinceModel::find($id);
}

function findDistrict($id)
{
    return DistrictModel::find($id);
}

function findCommune($id)
{
    return CommuneModel::find($id);
}

function findVillage($id)
{
    return VillageModel::find($id);
}

function findIllnessType($id)
{
    $ill = TypeOfIllness::find($id);
    return $ill;
}

function generate_voucher_number($number_ref, $digit)
{
    return str_pad($number_ref, $digit, "0", STR_PAD_LEFT);
}

function getVoucherType($key = '')
{
    $type =
        [
            '1' => 'Cash Receipt',
            '2' => 'Cash Disbursement',
            '3' => 'Cash Reimbursement',
            '4' => 'Cash Advance',
            '5' => 'Advance Settlement',
            '6' => 'Journal Entry/Adjustment'
        ];
    if ($key) {
        return @$type[$key];
    }
    return $type;
}

function getTaskType($key = '')
{
    $task = ['meeting' => 'Meeting', 'appointment' => 'Appointment', 'call_log' => 'Call_log'];
    if ($key) {
        return $task[$key];
    }
    return $task;
}

function get_source_type($key = null)
{
    $arr = ['contact' => __('administrator.contact_by'), 'known_from' => __('administrator.known_from')];
    if ($key) {
        return $arr[$key];
    }
    return $arr;
}

function getDealResult($key = null)
{
    $status = [
        '1' => __('administrator.success'),
        '5' => __('administrator.close_by_partner'),
        '2' => __('administrator.disposal'),
        '3' => 'Grade A (Above 50%)',
        '4' => 'Grade B (Below 50%)'
    ];

    if ($key) {
        return $status[$key];
    }
    return $status;
}

function bgDealStatus($key)
{
    switch ($key) {
        case 0:
        case 5:
            $color = 'warning';
            break;
        case 1:
            $color = 'success';
            break;
        case 2:
        case 3:
        case 4:
            $color = 'danger';
            break;
        default:
            $color = 'warning';
    }

    return '<span class="label label-' . $color . '">' . getDealResult($key) . '</span>';
}

function getTypeOfCustomer($key = null)
{
    $status = [
        '' => __('administrator.please_select'),
        'oc' => __('administrator.ordinary_client'),
        'rb' => __('administrator.royal_client_b'),
        'ra' => __('administrator.royal_client_a'),
        'hm' => __('administrator.health_maintainers'),
    ];
    if ($key) {
        return $status[$key];
    }
    return $status;
}

function genTypeOfCustomer($date1, $date2)
{
    $datetime1 = new DateTime($date1);
    $datetime2 = new DateTime($date2);
    $interval = $datetime1->diff($datetime2);
    $days = $interval->format('%a'); //get days

    if ($days < 44) {
        $toc = 'oc';
    } elseif ($days >= 45 && $days < 89) {
        $toc = 'rb';
    } elseif ($days > 90) {
        $toc = 'ra';
    } else {
        $toc = null;
    }

    return $toc;
}

function getGender($key = null)
{
    $gender = ['male' => __('administrator.male'), 'female' => __('administrator.female')];
    if ($key) {
        return $gender[$key];
    }
    return $gender;
}

function getCustomerIllnessJson($ill = null)
{
    $ill_text = '';
    if ($ill) {
        $ill = \App\Models\TypeOfIllness::whereIn('id', json_decode($ill))->pluck(if_kh() ? 'name_km' : 'name_en');
        $ill_text = $ill->implode(', ');
    }
    return $ill_text;
}

function generate_customer_bach($sale_date)
{
    $sale_date = date('d-m-Y', strtotime($sale_date));
    $first_date = '16-02-2021';
    $bach_day = 45;
    $bach_number = 11;
    $second_date = $first_date;
    while (1) {
        if ($bach_number !== 11) {
            $first_date = date('d-m-Y', strtotime($first_date . ' + ' . $bach_day . ' days'));
        }
        $second_date = date('d-m-Y', strtotime($second_date . ' + ' . $bach_day . ' days'));

        $strDate = strtotime($sale_date);
        $strFDate = strtotime($first_date);
        $strSDate = strtotime($second_date);
        $bach_number++;
        if ($strDate >= $strFDate && $strDate <= $strSDate) {
            break;
        }
        if ($bach_number > 1000) {
            break;
        }
    }

    return sprintf('%06d', $bach_number);
}

function pluckReason()
{
    return ReasonModel::pluck('reason', 'id');
}

function addJournal($journal_data)
{
    return JournalModel::create($journal_data);
}

function maxJournalId()
{
    return JournalModel::select(DB::raw("Max(id) as last_id"))->first()->last_id ?? 1;
}

function getPaymentType($key = null, $text = null)
{
    $data = ['pay_now' => __('administrator.pay_now'), 'pay_later' => __('administrator.' . ($text ?? 'payable'))];
    if ($key) {
        return $data[$key];
    }
    return $data;
}

function createProductAccountChart($product)
{
    $cog = '51000';
    $revenue = '41000';
    $inventory = '11006';
    $acc_cost_of_good_sold = $cog . $product->id;
    $acc_sale_revenue = $revenue . $product->id;
    $acc_inventory = $inventory . $product->id;
    $arr_product['acc_cost_of_good_sold'] = (int)$acc_cost_of_good_sold;
    $arr_product['acc_inventory'] = (int)$acc_inventory;
    $arr_product['acc_sale_revenue'] = (int)$acc_sale_revenue;
    ProductModel::where('id', $product->id)->update($arr_product);

    // account chart
    $data_cog = array(
        'id' => $acc_cost_of_good_sold,
        'branch_id' => 0,
        'user_id' => 0,
        'acc_name' => 'Cost Of Good Sold ' . $product->product_name,
        'acc_namekh' => 'Cost Of Good Sold ' . $product->product_name,
        'acctype' => $cog,
        'acc_des' => '',
        'acc_delete' => 1,
        'acc_brand_id' => Auth::user()->branch_id,
        'sub_acc' => 1,
    );
    AccountChartModel::updateOrCreate(['id' => $acc_cost_of_good_sold], $data_cog);

    $data_inventory = array(
        'id' => $acc_inventory,
        'branch_id' => 0,
        'user_id' => 0,
        'acc_name' => 'Inventory ' . $product->product_name,
        'acc_namekh' => 'Inventory ' . $product->product_name,
        'acctype' => $inventory,
        'acc_des' => '',
        'acc_delete' => 1,
        'acc_brand_id' => Auth::user()->branch_id,
        'sub_acc' => 1,
    );
    AccountChartModel::updateOrCreate(['id' => $acc_inventory], $data_inventory);

    $data_sr = array(
        'id' => $acc_sale_revenue,
        'branch_id' => 0,
        'user_id' => 0,
        'acc_name' => 'Sale Revenue ' . $product->product_name,
        'acc_namekh' => 'Sale Revenue ' . $product->product_name,
        'acctype' => $revenue,
        'acc_des' => '',
        'acc_delete' => 1,
        'acc_brand_id' => Auth::user()->branch_id,
        'sub_acc' => 1,
    );
    AccountChartModel::updateOrCreate(['id' => $acc_sale_revenue], $data_sr);


    return 'ok';
}

function CreateMemberAccountChart($member)
{
    $acc_ar = '11003';
    $acc_ap = '21001';

    $id_ar = $acc_ar . $member->id;
    $id_ap = $acc_ap . $member->id;
    $data_acc_chart = array(
        'id' => $id_ar,
        'branch_id' => FindBranchID(),
        'user_id' => Auth::user()->id,
        'acc_name' => 'Account Receivable - ' . $member->name,
        'acc_namekh' => 'ប្រាក់ដែលអតិថិជនជំពាក់ស្ថាប័ន - ' . $member->name,
        'acctype' => $acc_ar,
        'acc_des' => 'ប្រាក់ដែលអតិថិជនជំពាក់ស្ថាប័ន - ' . $member->name,
        'acc_delete' => 1,
        'acc_status' => 1,
        'sub_acc' => 1,
    );

    AccountChartModel::updateOrCreate(['id' => $id_ar], $data_acc_chart);

    $data_acc_chart['id'] = $id_ap;
    $data_acc_chart['branch_id'] = $member->id;
    $data_acc_chart['acctype'] = $acc_ap;
    $data_acc_chart['acc_name'] = 'Account Payable - ' . $member->name;
    $data_acc_chart['acc_namekh'] = 'សាច់ប្រាក់ដែលស្ថាប័នជំពាក់អ្នកផ្គត់ផ្គង់ - ' . $member->name;
    $data_acc_chart['acc_des'] = 'សាច់ប្រាក់ដែលស្ថាប័នជំពាក់អ្នកផ្គត់ផ្គង់ - ' . $member->name;
    AccountChartModel::updateOrCreate(['id' => $id_ap], $data_acc_chart);

    User::where('id', $member->id)->update(['acc_account_receivable' => $id_ar, 'acc_account_payable' => $id_ap]);
    return 'ok';
}


function uCan($can)
{
    return Auth::user()->can($can);
}

function myDate($date, $time = 0)
{
    return date('d-m-Y' . ($time ? ' H:i:s' : ''), strtotime($date));
}

function sDate($date, $time = 0)
{
    return date('Y-m-d' . ($time ? ' H:i:s' : ''), strtotime($date));
}

function ifMember($id = 0)
{
    return findUser($id ?: Auth::user()->id)->user_type === 'member';
}

function myParent()
{
    $parent = Auth::user()->leader_id;
    $parent = findUser($parent);
    $parent->type = $parent->user_type;
    if ($parent->type !== 'member') {
        $parent = findBranch($parent->branch_id);
    }
    return $parent;
}

function memberShelf($member_id)
{
    return ShelfModel::where('member_id', $member_id)->first();
}

function myMemberType($member_id = 0)
{
    $member_type_id = findUser($member_id ?: Auth::id())->member_type_id;
    return MemberTypeModel::find($member_type_id);
}

function stockMember($member_id, $product_unit_id)
{
    return StockModel::where(['member_id' => $member_id, 'product_unit_id' => $product_unit_id, 'type' => 'member'])->first();
}

function checkStockMember($member_id, $product_unit_id, $qty)
{
    $stock = stockMember($member_id, $product_unit_id);
    $product_unit = ProductUnitModel::find($product_unit_id);
    $qty *= $product_unit->qty_per_unit;
    if ($stock) {
        $product = getProductById($stock->product_id);
        if ($stock->stock_qty < $qty) {
            return $product->product_name . ' | ' . $stock->item_code . ' not enough';
        }
    } else {
        return 'Product doesn\'t exist';
    }
    return '';
}

function getProduct()
{
    return ProductModel::paginate(10);
}

function FIndlMonth($id)
{

    Fun::lang();
    if ($id == 1) {
        $month = __('administrator.January');
    } elseif ($id == 2) {
        $month = __('administrator.February');
    } elseif ($id == 3) {
        $month = __('administrator.March');
    } elseif ($id == 4) {
        $month = __('administrator.April');
    } elseif ($id == 5) {
        $month = __('administrator.May');
    } elseif ($id == 6) {
        $month = __('administrator.June');
    } elseif ($id == 7) {
        $month = __('administrator.July');
    } elseif ($id == 8) {
        $month = __('administrator.August');
    } elseif ($id == 9) {
        $month = __('administrator.September');
    } elseif ($id == 10) {
        $month = __('administrator.October');
    } elseif ($id == 11) {
        $month = __('administrator.November');
    } else {
        $month = __('administrator.December');
    }
    return $month;
}
