<?php
	namespace App\Classes;
	use DB;
	use App\LoanProcessModel;
	use App\LoanModel;

	class Reschedule
	{
		public function delete_schedule_payment($loan_id)
		{
			DB::delete("
				DELETE FROM nso007_loan_process 
				WHERE loanprocess_loanid = $loan_id 
				AND (loanprocess_paid is NULL OR loanprocess_paid = '' OR loanprocess_paid = 2)
			");
		}

		public function get_max_loan_process($loan_id)
		{
			$data = DB::select("
            	SELECT max(loanprocess_no) AS max_no FROM nso007_loan_process WHERE loanprocess_loanid = $loan_id
	        ");
	        return $data[0]->max_no;
		}

	    public function interest_installment($data, $loan_id)
	    {
	        extract($data);
	        
	        $paymentByStep = $loan_amount_payment; // Total paid in payment step
	        $loanprocess_amountpaid = $paymentByStep; // Total payment step

	        $amountLoan = $loan_amount_loan; // Old Total Price for monthly payment
	        $amount = $loan_amount; // Old Price
	        $duration = $loan_duration; // Duration pay
	        $interest = $loan_interest; // Interest
	        $principlePay = $amountLoan / $duration; // Payment for monthly
	        $amountOS = $amountLoan; // Old Total Price for monthly payment
	        $no = $loan_process_no + 1; // Count up +1 after payment step
	        $accPrinciple = $paymentByStep; // Old total paid in payment step
	        $accInterest = 0; // Old interest
	        $amountPaid = 0; // Old paid amount
	        $paid_alone = 0;
	        for($i = 0; $i < $duration; $i++){
	            $interestPay = ($amountOS * $interest / 100); // Calculate interest monthly
	            $principlePay = $principlePay; // Monthly payment
	            $amountOS -= $principlePay; // Old Total Price after paid monthly
	            $accPrinciple = ($accPrinciple + $principlePay);
	            $accInterest = ($accInterest + $interestPay);
	            $totalAmountCredit = $amountLoan + $interestPay;
	            $payment = ($principlePay + $interestPay);
	            $amountPaid += $payment ;
	            $loanprocess_amountpaid += $payment ;
	            $paid_alone += $principlePay;
	            $amountCredit = $amountLoan - $paid_alone;
	            //echo $principlePay.'<br>';
	            $data = array(
	                'loanprocess_loanid'       => $loan_id,
	                'loanprocess_no'           => $no,
	                'loanprocess_datepayment'  => date('Y-m-d',strtotime($loan_firstpaydate." + $i month")),
	                'loanprocess_interest'     => $interestPay,
	                'loanprocess_interestpay'  => $interestPay,
	                'loanprocess_principle'    => $principlePay,
	                'loanprocess_principlepay' => $principlePay,
	                'loanprocess_principleos'  => $amountOS,
	                'loanprocess_accprinciple' => $accPrinciple,
	                'loanprocess_accinterest'  => $accInterest,
	                'loanprocess_amountpaid'   => $loanprocess_amountpaid,
	                'loanprocess_amountcredit' => $amountCredit,
	                'loanprocess_owe'          => $payment,
	                'loanprocess_owepay'       => $payment,
	            );
	            LoanProcessModel::insert($data);
	            $no++;
	        }
	        $this->loan_duration_reschedule($loan_id, $duration);
	    }

	    public function client_payment_completed($id)
	    {
	    	LoanModel::where('id', $id)->update([
	    		'loan_amountos' => 0,
	    		'loan_status' 	=> 2,
	    		'loan_enddate'  => date('Y-m-d')
	    	]);
	    }

	    public function loan_duration_reschedule($loan_id, $duration)
	    {
	    	LoanModel::where('id', $loan_id)->update([
	    		'loan_duration' => $duration
	    	]);
	    }
	}
?>