<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('hr.branch.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php Fun::lang()?>
    <style>
        .jconfirm-content-pane input,
        .jconfirm-content-pane select,
        .jconfirm-content-pane textarea
        {
            margin-bottom: 10px;
        }
    </style>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.branch")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.manage_hr")); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.branch")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Branch Create')): ?>
                                    <a class="btn btn-sm btn-success create_branch" href="#"><span class="fa fa-plus"></span> <?php echo e(__("application.Create New")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_branch" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.name')); ?></th>
                                        <th><?php echo e(__('administrator.name_kh')); ?></th>
                                        <th><?php echo e(__('administrator.phone')); ?></th>
                                        <th><?php echo e(__('administrator.email')); ?></th>
                                        <th><?php echo e(__('administrator.address')); ?></th>
                                        <th><?php echo e(__('administrator.note')); ?></th>
                                        <th><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $branch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td><?php echo e($row->name); ?></td>
                                        <td><?php echo e($row->khmer_name); ?></td>
                                        <td><?php echo e($row->phone); ?></td>
                                        <td><?php echo e($row->email); ?></td>
                                        <td><?php echo e($row->address); ?></td>
                                        <td><?php echo e($row->note); ?></td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Branch Edit')): ?>
                                                <a data-href="<?php echo e(route('hr-branch.edit',$row->id)); ?>" class="btn btn-sm btn-warning btn_edit"
                                                   title="edit"><span class="fa fa-edit"></span> Edit</a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Branch set_main')): ?>
                                                <a href="#"
                                                   class="btn btn-sm btn-info <?php if($row->main==1): ?> button_primary <?php else: ?> button_info <?php endif; ?>"
                                                   data-id="<?php echo e($row->id); ?>" title="set"
                                                   <?php if($row->main==0): ?>
                                                   onclick="set_main('<?php echo e($row->id); ?>')"
                                                        <?php endif; ?>>
                                                    <?php if($row->main==1): ?>
                                                        <span class="fa fa-check"></span>
                                                        <?php echo e(__('administrator.main')); ?>

                                                    <?php else: ?>
                                                        <span class="fa fa-pen-fancy"></span>
                                                        <?php echo e(__('administrator.set')); ?>

                                                    <?php endif; ?>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">

        function set_main(id) {
            if ($.confirm({
                title: '<strong style="color:darkcyan;"><?php echo e(__('administrator.change_status')); ?></strong>',
                content: "<b>Want to Change Main Branch ? "
                + " </b>Then Click OK",

                buttons: {
                    '<?php echo e(__('administrator.cancel')); ?>': {
                        btnClass: 'btn-red',
                        action: function () {
                        }

                    },
                    '<?php echo e(__('administrator.ok')); ?>': {
                        btnClass: 'btn-blue',
                        action: function () {
                            $.ajax({
                                type: "GET",
                                dataType: "json",
                                url: '<?php echo e(route("hr.branch_changeStatus")); ?>',
                                data: {'id': id},
                                success: function (data) {
                                    location.reload();
                                }
                            });
                        }
                    }
                }
            }))

                return false;
        }

        var $form_content = `
                <input type="text" name="name" class="form-control border-red" required placeholder="<?php echo e(__('administrator.name')); ?>" maxlength="50" >
                <input type="text" name="name_kh" class="form-control border-red" required placeholder="<?php echo e(__('administrator.name_kh')); ?>" maxlength="50" >
                <input type="text" name="phone" class="form-control border-red" placeholder="<?php echo e(__('administrator.phone')); ?>" maxlength="50" >
                <input type="text" name="email" class="form-control border-red" placeholder="<?php echo e(__('administrator.email')); ?>" maxlength="50" >
                <textarea name="address" rows="2" maxlength="150" class="no-resize form-control border-red" placeholder="<?php echo e(__('administrator.address')); ?>" ></textarea>
                <textarea name="note" rows="3" maxlength="150" class="no-resize form-control" placeholder="<?php echo e(__('administrator.note')); ?>" ></textarea>
                `;
        $('.create_branch').on('click', function () {
            form($form_content, '<?php echo e(__('administrator.submit')); ?>', '<?php echo e(__('administrator.create')); ?>', '<?php echo e(route('hr-branch.store')); ?>');
        });
        $('.btn_edit').on('click', function () {
            var url = $(this).data('href');
            $.ajax({
                url: url,
                dataType: 'json',
                method: 'get'
            }).done(function (response) {
                console.log(response);
                form(
                    $form_content,
                    '<?php echo e(__('administrator.update')); ?>',
                    '<?php echo e(__('administrator.edit')); ?>',
                    '<?php echo e(route('hr-branch-update')); ?>',
                    response.name,
                    response.khmer_name,
                    response.phone,
                    response.email,
                    response.address,
                    response.note,
                    response.id
                );
            }).fail(function () {
                console.log(2);
            });
        });

        function form($fcontent = '', btntext = '', title = '', route = '', name = '', name_kh = '', phone = '', email = '', address = '', note = '', id = '') {
            $.confirm({
                title: title + ' <?php echo e(__('administrator.branch')); ?>',
                content: $fcontent,
                theme: 'modern',
                buttons: {
                    cancel: {
                        text: '<?php echo e(__('administrator.cancel')); ?>',
                        btnClass: 'btn btn-sm btn-red',
                        action: function () {

                        }
                    },
                    submit: {
                        text: btntext,
                        btnClass: 'btn btn-sm btn-info',
                        action: function () {
                            let self = this;
                            let phone = self.$content.find('input[name=phone]').val();
                            let name = self.$content.find('input[name=name]').val();
                            let name_kh = self.$content.find('input[name=name_kh]').val();
                            let email = self.$content.find('input[name=email]').val();
                            let address = self.$content.find('textarea[name=address]').val();
                            let note = self.$content.find('textarea[name=note]').val();
                            self.buttons.submit.disable();
                            $.ajax({
                                url: route,
                                dataType: 'json',
                                data: {
                                    "_token": "<?php echo e(csrf_token()); ?>",
                                    name: name,
                                    name_kh: name_kh,
                                    note: note,
                                    address: address,
                                    phone: phone,
                                    email: email,
                                    id: id,
                                },
                                method: 'post'
                            }).done(function (response) {
                                if (response === 'success') {
                                    window.location.reload();
                                }
                            }).fail(function (xhr) {
                                alertErrorFormController(xhr, self)
                            });
                            return false;
                        }
                    },
                }
            });

            if (id) {
                setTimeout(function () {
                    $(document).find('textarea[name=address]').text(address);

                    $(document).find('textarea[name=note]').text(note);
                    $(document).find('input[name=name]').val(name);
                    $(document).find('input[name=name_kh]').val(name_kh);
                    $(document).find('input[name=phone]').val(phone);
                    $(document).find('input[name=email]').val(email);
                    $(".focus").focus();
                }, 1);
            }
        }

        function alertErrorFormController(xhr, this_ = '')
        {
            let error1 = xhr.responseJSON.errors;
            let error2 = xhr.responseJSON.message;
            let text_err = '<ul class="text-left">';
            if (error1) {
                $.each(error1, function (i, val) {
                    let string = val[0].replace('The ', '');
                    let fletter = string.substr(0, 1);
                    let store = string.replace(fletter, fletter.toUpperCase());
                    text_err += '<li><span class="fa fa-caret-right text-danger"></span> ' + store + '</li>';
                });
            }
            if (error2) {
                text_err += '<li><span class="fa fa-caret-right text-danger"></span> ' + error2 + '</li>';
            }
            text_err += '</ul>';
            $.alert({
                title: '',
                content: text_err,
                useBootstrap: false,
                boxWidth: '25%',
                theme: 'modern',
                buttons: {
                    close: {
                        text: '<?php echo e(__('administrator.close')); ?>',
                        btnClass: 'button_warning',
                    }
                }
            });
            if (this_) {
                this_.buttons.submit.enable();
            }
        }

        $('#datatable_branch').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                },
            }

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/branch/index.blade.php ENDPATH**/ ?>