<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php echo $__env->make('hr.job-benefit.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.benefit_type")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.manage_hr')); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.benefit_type")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Benefit Type Create')): ?>

                                <a class="btn btn-sm btn-success" href="<?php echo e(route('hr-job-benefit.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.en_name')); ?></th>
                                        <th><?php echo e(__('administrator.kh_name')); ?></th>
                                        <th><?php echo e(__('administrator.amount')); ?></th>
                                        <th><?php echo e(__('administrator.note')); ?></th>
                                        <th style="width: 200px;"><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn_job_benefit', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "<?php echo e(route('datatable.hr-get-job-benefit')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'name'},
                        {data: 'name_kh'},
                        {data: 'amount'},
                        {data: 'note'},
                        {data: 'action', searchable: false},
                    ],

                "initComplete": function (settings, json) {
                    $('#datatable_products tbody :not(script)').contents().filter(function () {
                        return this.nodeType === 3;
                    }).replaceWith(function () {
                        return this.nodeValue.replace(/full_day/g, '<?php echo e(__('administrator.full_day')); ?>').replace(/half_day/g, '<?php echo e(__('administrator.half_day')); ?>').replace(/day_off/g, '<?php echo e(__('administrator.day_off')); ?>');
                    });
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/job-benefit/index.blade.php ENDPATH**/ ?>