<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__('administrator.evaluation')); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.manage_hr')); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.evaluation')); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Evaluation Create')): ?>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(route('hr-evaluation.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.employee')); ?></th>
                                        <th><?php echo e(__('administrator.date')); ?></th>
                                        <th style="width: 200px"><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "<?php echo e(route('hr-evaluation.index')); ?>",
                columns:[
                    {data: 'DT_RowIndex', searchable: false},
                    {data: 'employee'},
                    {data: 'date'},
                    {data: 'action', searchable: false},
                ]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/evaluation/index.blade.php ENDPATH**/ ?>