<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php echo $__env->make('hr.department.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.department")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.manage_hr")); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.department")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Department Create')): ?>
                                    <a class="btn btn-sm btn-success create_branch" href="<?php echo e(route('hr-department.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("application.Create New")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_department" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.code')); ?></th>
                                        <th><?php echo e(__('administrator.khmer_name')); ?></th>
                                        <th><?php echo e(__('administrator.english_name')); ?></th>
                                        <th><?php echo e(__('administrator.note')); ?></th>
                                        <th style="width: 200px"><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete_department', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatable_department').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "<?php echo e(route('datatable.hr-get-department')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex',orderable: false, searchable: false },
                        {data: 'code'},
                        {data: 'khmer_name'},
                        {data: 'english_name'},
                        {data: 'note'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/department/index.blade.php ENDPATH**/ ?>