<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> <?php echo e(__("application.List")); ?> <?php echo e(__("application.Product")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Construction Management")); ?></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Product")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header" id="card-search-report">
              <h3><?php echo e(__("application.Filtering")); ?></h3>
              <div class="pull-left">
                  <div class="row">
                      <div class="col-md-4">
                          <div class="form-group">
                              <strong><?php echo e(__("application.Category")); ?>:</strong>
                              <?php echo Form::select('category_id[]',$categories,null, array('class' => 'form-control select2','id'=>'category-id','multiple')); ?>

                          </div>
                      </div>
                      <div class="col-md-4">
                          <div class="form-group">
                              <strong><?php echo e(__("application.Unit")); ?>:</strong>
                              <?php echo Form::select('unit_id[]',$units,null, array('class' => 'form-control select2','id'=>'unit-id','multiple')); ?>

                          </div>
                      </div>
                      <div class="col-md-4">
                        <button class="btn btn-info btn-md" id="search-form" style="margin-top:18px;"><?php echo e(__("application.Search")); ?></button>
                    </div>
                  </div>
              </div>
            </div>
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="<?php echo e(route('product-construction.create')); ?>"> <?php echo e(__("application.Create New")); ?></a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-product" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th><?php echo e(__('application.No')); ?></th>
                  <th><?php echo e(__('application.Image')); ?></th>
                  <th><?php echo e(__('application.Product')); ?>​ <?php echo e(__('application.Code')); ?></th>
                  <th><?php echo e(__('application.Product')); ?> <?php echo e(__('application.Name')); ?></th>
                  <th><?php echo e(__('application.Category')); ?> </th>
                  <th><?php echo e(__('application.Unit')); ?></th>
                  <th><?php echo e(__('application.Unit')); ?> <?php echo e(__('application.Price')); ?></th>
                  <th><?php echo e(__('application.Qty')); ?></th>
                  <th><?php echo e(__('application.Action')); ?></th>
                </tr>
                </thead>
                
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>  
  function show_image(product_id){
    var route = "<?php echo e(route('show_product_image',':id')); ?>";
    route = route.replace(":id",product_id);
    $(".main-spinner").show();
    $.ajax({
      url:route,
      type:"GET",
      dataType:"JSON",
      async:false,
      success:function(data){
        $(".main-spinner").hide();
        var opt = "";
        $.each(data,function(index,value){
          opt += `<div class="col-md-12" width="100%" height="50%"><img src = "${value}" width="100%"></div>`;
        });
        $.confirm({
            title: 'Image',
            content:opt,
            onContentReady: function () {
                var self = this;
                /*this.setContentPrepend('<div>Prepended text</div>');*/
                /*setTimeout(function () {
                    self.setContentAppend('<div>Appended text after 2 seconds</div>');
                }, 2000);*/
            },
            columnClass: 'medium',
        });
      },
      error:function(){
        $(".main-spinner").hide();
          return "Erro !"
      }
    });
  }
  function con_delete(obj){
    let route = $(obj).data('href');
    $.confirm({
        title:'Are you sure ?',
        content:'',
        theme:'modern',
        buttons:{
            cancel:{
                btnClass:'btn btn-primary',
                text:'Cancel',
                action:function () {

                }
            },
            submit:{
                btnClass:'btn btn-danger',
                text:"Delete",
                action:function () {
                        $.ajax({
                          url:route,
                          type:"GET",
                          dataType:"JSON",
                          success:function(data){
                            let item_id = data.product_id;
                            if($(`tbody tr#${item_id}`).hasClass("parent")){
                              $(`tbody tr#${item_id}`).next().remove();
                              $(`tbody tr#${item_id}`).remove();
                            }else{
                              $(`tbody tr#${item_id}`).remove();
                            }
                          },
                          error:function(){

                          }
                        });
                        // window.location.replace(route);
                }
            },
        },
    });
  }
  $(document).ready(function() {
      $('.main-spinner').show();
      var Principle;var Interest;var Total_pay;
      $('#datable-product').DataTable({  
          "autoWidth": false,
          ordering: true,
          serverSide: true,
          responsive: false, 
          "searching": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000,-1], [20, 30, 50, 100,200,500,1000,'All']],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              }
          ],
          ajax: {
            url:"<?php echo e(route('product-construction.index')); ?>",
            type:"GET",
            data:function(d){
              d.category_id = $("#category-id").val();
              d.unit_id = $("#unit-id").val();
            }
          },
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false,orderable: false},
              {data: 'image','searchable': false,orderable: false},
              {data: 'pro_code'},
              {data: 'pro_name'},
              {data: 'pcat_name'},
              {data: 'unit_name'},
              {data: 'pro_price'},
              {data: 'pro_qty'},
              {data: 'action'},
          ],

          "columnDefs": [
            { "width": "85px", "targets": 1 },
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          },
      }); 
      $.fn.dataTable.ext.errMode = 'throw';
  });
  $(document).on("click","#search-form",function(){
    $('#datable-product').DataTable().draw(true);
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/construction-stock/products/index.blade.php ENDPATH**/ ?>