<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php echo $__env->make('hr.holiday.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('hr.holiday.import-excel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.holiday")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.manage_hr')); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.holiday")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Holiday Create')): ?>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(route('hr-holiday.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_holiday" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.holiday')); ?></th>
                                        <th><?php echo e(__('administrator.from_date')); ?></th>
                                        <th><?php echo e(__('administrator.to_date')); ?></th>
                                        <th><?php echo e(__('administrator.year')); ?></th>
                                        <th><?php echo e(__('administrator.note')); ?></th>
                                        <th style="width: 200px;"><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn_del_holiday', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $('#datatable_holiday').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "<?php echo e(route('hr.get-holiday')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex', orderable: false, searchable: false},
                        {data: 'name_en'},
                        {data: 'from_date'},
                        {data: 'to_date'},
                        {data: 'year'},
                        {data: 'note'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/holiday/index.blade.php ENDPATH**/ ?>