<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.List")); ?> <?php echo e(__("application.Client Payment")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.POS Operation")); ?></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Client Payment")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-header" id="card-search-report">
              <h2><?php echo e(__("application.Filtering")); ?></h2>
              <div class="pull-left">
                  <div class="row">
                      <div class="col-md-6">
                          <div class="form-group">
                              <strong><?php echo e(__("application.Category")); ?>:</strong>
                              <?php echo Form::select('category_id',$categories,null, array('class' => 'form-control select2','id'=>'category-id')); ?>

                          </div>
                          <div class="form-group">
                              <strong><?php echo e(__("application.Block")); ?>:</strong>
                              <?php echo Form::select('block',[],null, array('class' => 'form-control select2','id'=>'display-block')); ?>

                          </div>
                      </div>
                      <!-- /.col -->
                      <div class="col-md-6">
                          <div class="form-group">
                              <strong><?php echo e(__("application.Project")); ?>:</strong>
                              <?php echo Form::select('project',$projects,null, array('class' => 'form-control select2','id'=>'project-id')); ?>

                          </div>
                          <div class="form-group">
                              <strong><?php echo e(__("application.Item")); ?> <?php echo e(__("application.Name")); ?>:</strong>
                              <?php echo Form::select('item_id',$items,null, array('class' => 'form-control select2','id'=>'item-id')); ?>

                          </div>
                      </div>
                      <!-- /.col -->
                      <div class="col-md-6">
                          <button class="btn btn-success btn-md" id="search-form"><?php echo e(__("application.Search")); ?></button>
                      </div>
                  </div>
              </div>
          </div>
            <div class="card-body table-responsive">
              <table id="datable-client-payment" class="table table-bordered table-hover text-nowrap">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  <th><?php echo e(__("application.Code")); ?> <?php echo e(__("application.Client")); ?> </th>
                  <th><?php echo e(__("application.Client")); ?> <?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Client")); ?> <?php echo e(__("application.Phone")); ?></th>
                  <th><?php echo e(__("application.Gender")); ?></th>
                  <th><?php echo e(__("application.Date of Birth")); ?></th>
                  <th><?php echo e(__("application.Address")); ?></th>
                  <th><?php echo e(__("application.Action")); ?></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datable-client-payment').DataTable({
          "autoWidth": false,
          ordering: false,
          serverSide: true,
          "scrollY": screen.height,
          "scrollX": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              }
          ],
          ajax: {
            url:"<?php echo e(route('client-payment.get_client_payment')); ?>",
            type:"GET",
            data:function(d){
              var category_id = $("#category-id").val();
              var item_id = $("#item-id").val();
              var project_id = $("#project-id").val();

              d.category_id=category_id;
              d.item_id=item_id;
              d.project_id=project_id;
              d.block_id = $("#display-block").val();
            }
          },
          columns:
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'code','name':'nso007_client.id'},
              {data: 'name','name':'nso007_client.name'},
              {data: 'phone','name':'nso007_client.phone'},
              {data: 'gender','name':'nso007_client.gender'},
              {data: 'date_of_birth','name':'nso007_client.date_of_birth'},
              {data: 'address','searchable': false},
              {data: 'action','searchable': false},
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });
  $(document).on("click","#search-form",function(){
    $('#datable-client-payment').DataTable().draw(true);
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/client-payment/index.blade.php ENDPATH**/ ?>