<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> <?php echo e(__("application.Return")); ?> <?php echo e(__("application.Stock")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Construction Management")); ?></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Using")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            <?php echo Form::open(array('route' => 'usings.return_stock_store','method'=>'POST','enctype'=>'multipart/form-data')); ?>

                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row m-1" style="border:1px solid gray;padding: 15px;position: relative;">
                            <h4 style="position: absolute;top:-17px;left: 10px;background-color: white;color:#2E64FE">&nbsp;Product Info&nbsp;</h4>
                              <div class="col-md-6">
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Invoice")); ?> <?php echo e(__("application.Number")); ?></strong>
                                    <?php echo Form::number('invoice', null, array('placeholder' => __('application.Invoice')." ".__('application.Number'),'class' => 'form-control','required','id'=>'invoice-number')); ?>

                                </div>
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Qty")); ?> <span id="unit"></span></strong>
                                     <?php echo Form::text('pro_qty0', null, array('placeholder' => __('application.Qty'),'class' => 'form-control','id'=>'pro-qty')); ?>

                                </div>
                              </div>
                              <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Product")); ?>:</strong>
                                    <select class="select2 form-control change_prefix_address product_list" id="product" name="pro_name0">
                                        <option value="">Please Select Product</option>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option id="pro_<?php echo e($pro->id); ?>" value="<?php echo e($pro->id); ?>" unit="<?php echo e($pro->unit_name); ?>" code="<?php echo e($pro->pro_code); ?>" pro_name="<?php echo e($pro->pro_name); ?>" pro_id="<?php echo e($pro->id); ?>" pro_total_qty="<?php echo e($pro->pro_qty); ?>"><?php echo e($pro->pro_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                              </div>
                              <div class="row">&nbsp;</div>
                              <div class="col-md-12">
                                <button type="button" class="btn btn-info btn-sm" id="submit-proinfo"><?php echo e(__('application.Submit')); ?></button>
                              </div>
                              <div class="row">&nbsp;</div>
                              <div class="row"><br></div>
                              <table class="table table-bordered table-hover m-2" id="product-detail">
                                <thead>
                                  <tr>
                                      <th><?php echo e(__('application.Code')); ?> <?php echo e(__('application.Product')); ?></th>
                                      <th><?php echo e(__('application.Product')); ?> <?php echo e(__('application.Name')); ?></th>
                                      <th><?php echo e(__('application.Unit')); ?></th>
                                      <th><?php echo e(__('application.Qty')); ?></th>
                                      <th><?php echo e(__('application.Action')); ?></th>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                          </div>
                        
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> <?php echo e(__("application.Back")); ?></button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> <?php echo e(__("application.Save")); ?></button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            <?php echo Form::close(); ?>

        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(document).on("change","#invoice-number",function () {
        var num=$(this).val();
        var opt;
        $.ajax({
            dataType:'json',
            type:'post',
            url:'<?php echo e(route("usings.return_get_item")); ?>',
            data:{
                '_token':'<?php echo e(csrf_token()); ?>',
                'invoice':num
            },
            success:function(data) {
                $.each(data,function (index,value) {
                    opt+='<option id="pro_'+value.product_id+'" value="'+value.product_id+'" unit="'+value.unit_name+'"  pro_name="'+value.pro_name+'" pro_id="'+value.product_id+'" code="'+value.pro_code+'">'+value.pro_name+'</option>';
                })
                $("#invoice-number").empty();
                $("#invoice-number").append(opt);
            }
        });

    });
    $(document).on('click', '#submit-proinfo', function() {
        var val = $('.product_list').find(':selected').val();
        var pro_id = $('.product_list').find(':selected').attr('pro_id');
        var name = $('.product_list').find(':selected').attr('pro_name');
        var unit = $('.product_list').find(':selected').attr('unit');
        var code = $('.product_list').find(':selected').attr('code');
        var qty= $("#pro-qty").val();
        if(val == ""){
            $.alert({
                title: 'Alert!',
                content: 'Please Select Product!',
            });
        }
        else if (code == "" || name == "" || qty == "" || unit == "") {
            $.alert({
                title: 'Alert!',
                content: 'Please Input Qty and Price!',
            });
        } else {
            var meme = false;
            $('.product_code').each(function() {
                var $post = $(this);
                if ($(this).val() == code) {
                    $.alert({
                        title: 'Duplicate Fields!',
                        content: 'This Product is Already Added!',
                    });

                    meme = true;
                    $post.addClass('focus');
                    setTimeout(function() {
                        $post.removeClass('focus');
                    }, 4000);
                    $('html, body').animate({
                        scrollTop: $post.offset().top
                    }, 1000);
                }
            });
            if (meme == false) {
                $('#product-detail').append(add_item(code, name, unit, qty,pro_id));
            }

        }
    });
    $(document).on('click', '.btn-remove', function() {
        $(this).parent().parent().remove();
    });

    function add_item(code, name, unit, qty,pro_id) {
        return `<tr>
                    <td><input type="text" name="product_code[]" id="" value="${code}" class="form-control product_code" readonly><input type="hidden" name="product_id[]" id="" value="${pro_id}" class="form-control product_code" readonly></td>
                    <td><input type="text" name="product_name[]" id="" value="${name}" class="form-control" readonly></td>
                    <td><input type="text" readonly name="product_price[]" id="" value="${unit}" class="form-control"></td>
                    <td><input type="text" name="product_qty[]" id="" value="${qty}" class="form-control"></td>
                    <td><button type="button" class="btn-remove btn btn-md btn-danger"><i class="fa fa-times"></i></button></td>
                </tr>`;
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/construction-stock/usings/return.blade.php ENDPATH**/ ?>