<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> <?php echo e(__("application.Create")); ?> <?php echo e(__("application.Using")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Construction Management")); ?></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Using")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            <?php echo Form::open(array('route' => 'usings.store','method'=>'POST','enctype'=>'multipart/form-data')); ?>

                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Block")); ?> <?php echo e(__("application.Name")); ?>:</strong>
                                     <?php echo Form::select('blog_id',$blogs, null, array('class' => 'form-control select2','id'=>'blog-id','required')); ?>

                                </div>
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Date")); ?>:</strong>
                                     <?php echo Form::text('date', null, array('placeholder' => __('application.Date'),'class' => 'form-control date_picker','required')); ?>

                                </div>
                                
                            </div>    
                          <!-- /.col -->
                        </div>
                        <div class="row m-1" style="border:1px solid gray;padding: 15px;position: relative;">
                            <h4 style="position: absolute;top:-17px;left: 10px;background-color: white;color:#2E64FE">&nbsp;Product Info&nbsp;</h4>
                              <div class="col-md-6">
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Category")); ?></strong>
                                    <?php echo Form::select('pro_category_id',$category, null, array('class' => 'form-control select2','id'=>'pro_category_id')); ?>

                                </div>
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Qty")); ?> <span id="unit"></span></strong>
                                     <?php echo Form::text('pro_qty0', null, array('placeholder' => __('application.Qty'),'class' => 'form-control','id'=>'pro-qty')); ?>

                                </div>
                              </div>
                               <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required"><?php echo e(__("application.Product")); ?>:</strong>
                                        <select class="select2 form-control change_prefix_address product_list" id="product" name="pro_name0">
                                            <option value="">please select product</option>}
                                            option
                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option id="pro_<?php echo e($pro->id); ?>" value="<?php echo e($pro->id); ?>" unit="<?php echo e($pro->unit_name); ?>" code="<?php echo e($pro->pro_code); ?>" pro_name="<?php echo e($pro->pro_name); ?>" pro_id="<?php echo e($pro->id); ?>" pro_total_qty="<?php echo e($pro->balance_qty); ?>"><?php echo e($pro->pro_name); ?></option>}
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <strong><?php echo e(__("application.Person")); ?> <?php echo e(__("application.Use")); ?></strong>
                                        <?php echo Form::text('person_use', null, array('placeholder' => __('application.Name'),'class' => 'form-control')); ?>

                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <strong><?php echo e(__("application.Description")); ?></strong>
                                         <?php echo Form::textarea('remark', null, array('placeholder' => __('application.Description'),'class' => 'form-control','rows'=>'4')); ?>

                                    </div>
                                </div>
                              
                              <div class="col-md-12">
                                <button type="button" class="btn btn-info btn-sm" id="submit-proinfo"><?php echo e(__('application.Submit')); ?></button>
                              </div>
                              <div class="row">&nbsp;</div>
                              <div class="row"><br></div>
                              <table class="table table-bordered table-hover m-2" id="product-detail">
                                <thead>
                                  <tr>
                                      <th><?php echo e(__('application.Code')); ?> <?php echo e(__('application.Product')); ?></th>
                                      <th><?php echo e(__('application.Product')); ?> <?php echo e(__('application.Name')); ?></th>
                                      <th><?php echo e(__('application.Unit')); ?></th>
                                      <th><?php echo e(__('application.Qty')); ?></th>
                                      <th><?php echo e(__('application.Action')); ?></th>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                          </div>
                        
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> <?php echo e(__("application.Back")); ?></button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> <?php echo e(__("application.Save")); ?></button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            <?php echo Form::close(); ?>

        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(document).on("change","#product",function () {
        $("#unit").empty();
        $("#unit").append("("+$(this).find(':selected').attr("unit")+")");
    });
    $(document).on("change","#pro_category_id",function () {
        var id=$("#pro_category_id").val();
        var blog_id=$("#blog-id").val();
        if(blog_id==0 || isNaN(blog_id)){
            $.alert({
                title: 'Alert!',
                content: 'Please Select Block.',
            });
            $("#pro_category_id").empty();
            $("#pro_category_id").append("<option value='' disabled selected>please select</option>");
        }
        var opt=`<option value='' disabled selected>please select</option>`;
        $(".main-spinner").show();
        $.ajax({
            dataType:'json',
            type:'post',
            url:'<?php echo e(route("get_product_by_cate")); ?>',
            data:{
                '_token':'<?php echo e(csrf_token()); ?>',
                'pro_category_id':id,
                'blog_id':blog_id
            },
            success:function (data) {
                $("#product").empty();
                $.each(data,function (index,value) {
                    opt+=`<option id="pro_${value.id}" value="${value.id}" unit="${value.unit_name}" code="${value.pro_code}" pro_name="${value.pro_name}" pro_id="${value.id}" pro_total_qty="${value.balance_qty}">${value.pro_name}</option>`;
                });
                $("#product").append(opt);
            },
            complete:function(){
                $(".main-spinner").hide();
            }
        });
    })
    $(document).on('change','#pro-qty',function(){
        var proTotalQty=parseInt($('.product_list').find(":selected").attr("pro_total_qty"));
        var qty = parseInt($(this).val());
        var unit = $('.product_list').find(':selected').attr('unit');
        if(isNaN(proTotalQty)){
            $.alert({
                title: 'Alert!',
                content: 'Please Purchase product.',
            });
            $(this).val(0);
            qty=0;
        }
        if(qty>proTotalQty){
            $.alert({
                title: 'Alert!',
                content: 'This product have only '+proTotalQty+' '+unit+' in stock.',
            });
            $(this).val(0);
            qty=0;
        }
    });
    $(document).on('keyup','#pro-qty',function(){
        var proTotalQty=parseInt($('.product_list').find(":selected").attr("pro_total_qty"));
        var qty = parseInt($(this).val());
        var unit = $('.product_list').find(':selected').attr('unit');
        if(isNaN(proTotalQty)){
            $.alert({
                title: 'Alert!',
                content: 'Please select product.',
            });
            $(this).val(0);
            qty=0;
        }
        if(qty>proTotalQty){
            $.alert({
                title: 'Alert!',
                content: 'This product have only '+proTotalQty+' '+unit+' in stock.',
            });
            $(this).val(0);
            qty=0;
        }
    });
    $(document).on('click', '#submit-proinfo', function() {
        var val = $('.product_list').find(':selected').val();
        var code = $('.product_list').find(':selected').attr('code');
        var pro_id = $('.product_list').find(':selected').attr('pro_id');
        var name = $('.product_list').find(':selected').attr('pro_name');
        var qty = $('#pro-qty').val();
        var unit = $('.product_list').find(':selected').attr('unit');
        if(val == ""){
            $.alert({
                title: 'Alert!',
                content: 'Please Select Product!',
            });
        }
        else if (code == "" || name == "" || qty == "" || unit == "") {
            $.alert({
                title: 'Alert!',
                content: 'Please Input Qty and Price!',
            });
        } else {
            var meme = false;
            $('.product_code').each(function() {
                var $post = $(this);
                if ($(this).val() == code) {
                    $.alert({
                        title: 'Duplicate Fields!',
                        content: 'This Product is Already Added!',
                    });

                    meme = true;
                    $post.addClass('focus');
                    setTimeout(function() {
                        $post.removeClass('focus');
                    }, 4000);
                    $('html, body').animate({
                        scrollTop: $post.offset().top
                    }, 1000);
                }
            });
            if (meme == false) {
                $('#product-detail').append(add_item(code, name, unit, qty,pro_id));
            }

        }
        $('#pro-qty').val("");
    });
    $(document).on('click', '.btn-remove', function() {
        $(this).parent().parent().remove();
    });

    function add_item(code, name, unit, qty,pro_id) {
        return `<tr class="col-sm-12 form-group">
                    <td><input type="text" name="product_code[]" id="" value="${code}" class="form-control product_code" readonly><input type="hidden" name="product_id[]" id="" value="${pro_id}" class="form-control product_code" readonly></td>
                    <td><input type="text" name="product_name[]" id="" value="${name}" class="form-control" readonly></td>
                    <td><input type="text" readonly name="product_price[]" id="" value="${unit}" class="form-control"></td>
                    <td><input type="text" name="product_qty[]" id="" value="${qty}" class="form-control" readonly></td>
                    <td><button type="button" class="btn-remove btn btn-sm btn-danger"><i class="fa fa-times"></i></button></td>
                </tr>`;
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/construction-stock/usings/create.blade.php ENDPATH**/ ?>