<?php $__env->startSection("content"); ?>
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.Edit")); ?> <?php echo e(__("application.Project")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Manage POS Stock")); ?></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Project")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            <?php echo Form::model($project, ['method' => 'PATCH','route' => ['project.update', $project->id],'enctype' => 'multipart/form-data']); ?>

                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Name")); ?>:</strong>
                                    <?php echo Form::text('name', null, array('placeholder' => __("application.Name"),'class' => 'form-control','required')); ?>

                                </div>
                                <div class="form-group">
                                    <strong><?php echo e(__("application.House")); ?> <?php echo e(__("application.Number")); ?>:</strong>
                                    <?php echo Form::text('house_number', null, array('placeholder' => __("application.House")." ".__("application.Number"),'class' => 'form-control')); ?>

                                </div>
                                
                                <div class="form-group">
                                    <strong><?php echo e(__("application.District")); ?>:</strong>
                                    <?php if(empty($project->get_district['district_id'])): ?>
                                    <select name="district" id="p_district" class="form-control select2">
                                        <option value="" selected>Please select</option>
                                    </select>
                                    <?php else: ?>
                                    <select name="district" id="p_district" class="form-control select2">
                                        <option value="<?php echo e($project->get_district['district_id']); ?>" selected><?php echo e($project->get_district['district_id']); ?> <?php echo e($project->get_district['district_en']); ?> <?php echo e($project->get_district['district_km']); ?></option>
                                    </select>
                                    <?php endif; ?>
                                </div>
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Village")); ?>:</strong>
                                    <select name="village" id="p_village" class="form-control select2">
                                        <?php if(empty($project->get_village['village_id'])): ?>
                                        <option value="" selected>Please select</option>
                                        <?php else: ?>
                                        <option value="<?php echo e($project->get_village['village_id']); ?>"><?php echo e($project->get_village['village_id']); ?> <?php echo e($project->get_village['village_en']); ?> <?php echo e($project->get_village['village_km']); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">

                                <div class="form-group">
                                    <strong><?php echo e(__("application.Street")); ?> <?php echo e(__("application.Number")); ?>:</strong>
                                    <?php echo Form::text('street_number', null, array('placeholder' => __("application.Street")." ".__("application.Number"),'class' => 'form-control')); ?>

                                </div>
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Province")); ?>:</strong>
                                    <?php echo Form::select('province',$provinces,$project->province_id, array('class' => 'form-control select2','id'=>'p_province')); ?>

                                </div>
                                
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Commune")); ?>:</strong>
                                    <select name="commune" id="p_commune" class="form-control select2">
                                        <?php if(empty($project->commune)): ?>
                                        <option value="" selected>Please select</option>
                                        <?php else: ?>
                                        <option value="<?php echo e($project->commune); ?>" selected><?php echo e($project->get_commune['commune_id']); ?> <?php echo e($project->get_commune['commune_en']); ?> <?php echo e($project->get_commune['commune_km']); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Description")); ?></strong>
                                    <?php echo Form::textarea('description', null, array('class' => 'form-control','placeholder'=>__("application.Description"),'rows'=>'5')); ?>

                                </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> <?php echo e(__("application.Back")); ?></button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> <?php echo e(__("application.Save")); ?></button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            <?php echo Form::close(); ?>

        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="<?php echo e(asset('assets/js/location.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/project/edit.blade.php ENDPATH**/ ?>