<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.List")); ?> <?php echo e(__("application.Project")); ?> </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Manage POS Stock")); ?></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Project")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Project-Create')): ?>
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="<?php echo e(route('project.create')); ?>"> <?php echo e(__("application.Create New")); ?></a>
              </div>
            </div>
            <?php endif; ?>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-project" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  <th><?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Address")); ?></th>
                  <th><?php echo e(__("application.Description")); ?></th>
                  <th><?php echo e(__("application.Action")); ?></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="<?php echo e(asset('assets/js/location.js')); ?>"></script>
<script>
    function show_info(id){
      var route="<?php echo e(route('customer.show',':id')); ?>";
      route=route.replace(":id",id);
      $('.main-spinner').show();
      $.ajax({
        url:route,
        type:"GET",
        dataType:"JSON",
        success:function(data){
          $('.main-spinner').hide();
          $("#ag-name").empty();
          $("#ag-name").append(data.name);
          if(data.name==null) 
            $(".show-name").hide();
          $("#ag-nick-name").empty();
          $("#ag-nick-name").append(data.nick_name);
          if(data.nick_name==null)
            $(".show-nick-name").hide();
          $("#ag-gender").empty();
          $("#ag-gender").append(data.gender);
          if(data.gender==null)
            $(".show-gender").hide();
          $("#ag-phone").empty();
          $("#ag-phone").append(data.phone);
          if(data.phone==null)
            $(".show-phone").hide();
          $("#ag-dob").empty();
          $("#ag-dob").append(data.date_of_birth);
          if(data.date_of_birth==null)
            $(".show-dob").hide();
          $("#ag-nation").empty();
          $("#ag-nation").append(data.nationality);
          if(data.nationality==null)
            $(".show-nation").hide();
          $("#ag-des").empty();
          $("#ag-des").append(data.description);
          if(data.description==null)
            $(".show-des").hide();
          $("#ag-type").empty();
          if(data.type==0)
            $("#ag-type").append("<p class='text-success'>Customer</p>"); 
          if(data.type==1)     
             $("#ag-type").append("<p class='text-success'>Client</p>");
          $("#ag-address").empty();
          $(".show-address").hide();
          var address="";
          if(data.house_number!=null) 
            {
               $(".show-address").show();
              address+=data.house_number;
            }
          if(data.street_number!=null) 
            {
              $(".show-address").show();
              address+=" "+data.street_number;
            }
          if(data.get_village['village_km']!=null) 
          {
            $(".show-address").show();
            address+="​ ភូមិ​​ "+data.get_village['village_km'];
          }
          if(data.get_commune['commune_km']!=null) 
          {
            $(".show-address").show();
            address+=",​ ឃុំ "+data.get_commune['commune_km'];
          }
          if(data.get_district['district_km']!=null) 
            {
              $(".show-address").show();
              address+=", ស្រុក"+data.get_district['district_km'];
            }
          if(data.get_province['province_km']!=null) 
            {
              $(".show-address").show();
              address+=", ខេត្ត"+data.get_province['province_km'];
            }
          $("#ag-address").append(address);
        }
      });
    }
    $(document).ready(function() {
        $('.main-spinner').show();
        $('#datable-project').DataTable({  
            "autoWidth": false,
            ordering: false,
            serverSide: true,
            "scrollY": screen.height,
            "scrollX": true,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
            ajax: "<?php echo e(route('project.datatable_get_project')); ?>",
            columns: 
            [
                {data: 'DT_RowIndex','searchable': false},
                {data: 'name','name':'nso007_project_stock.name'},  
                {data: 'address','name':'nso007_project_stock.address'}, 
                {data: 'description','name':'nso007_project_stock.description'}, 
                {data: 'action','searchable': false}, 
            ],

            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
  function changeStatus(obj){
    $('.main-spinner').show();
    var id=$(obj).attr("id");
    var state=$(obj).attr("state");
    console.log(state);
    var route = "<?php echo e(route('user.update_status',':id')); ?>";
    route = route.replace(':id',id);
    $.ajax({
      type:"GET",
      dataType:"JSON",
      url:route,
      data:{
        '_token':"<?php echo e(csrf_token()); ?>"
      },
      success:function(data){
        $('.main-spinner').hide();
        if(data=="OK"){
          $("#"+id).empty();
          if(state==1){
            $("#"+id).append('<i style="padding:4px 8px 4px 6px;margin-right: -38px !important;" class="bg-danger">OFF</i>');
            $("#"+id).attr("state","0");
          }else if(state==0){
            $("#"+id).append('<i style="padding:4px 10px 4px 8px;margin-left: -37px !important;" class="bg-success">ON</i>');
            $("#"+id).attr("state","1");
          }
          toastr.success("User change state successfully !");
        }
      }
    });
  }
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/project/index.blade.php ENDPATH**/ ?>