<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.Report")); ?> <?php echo e(__("application.Client Payment")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Client Payment")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <?php echo $__env->make("report.operation.payment-form-search",compact("categories","projects","items"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-payment" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  <th><?php echo e(__("application.Date")); ?></th>
                  <th><?php echo e(__("application.Item")); ?></th>
                  
                  <th><?php echo e(__("application.Category")); ?></th>
                  <th><?php echo e(__("application.Client")); ?> <?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Client")); ?> <?php echo e(__("application.Phone")); ?></th>
                  <th><?php echo e(__("application.Agency")); ?></th>
                  <th><?php echo e(__("application.Paid")); ?>(%)</th>
                  <th><?php echo e(__("application.Duration")); ?></th>
                  <th><?php echo e(__("application.Sale")); ?> <?php echo e(__("application.Price")); ?></th>
                  <th><?php echo e(__("application.Discount")); ?></th>
                  <th><?php echo e(__("application.Sale")); ?> <?php echo e(__("application.Amount")); ?></th>
                  <th><?php echo e(__("application.Payment")); ?> <?php echo e(__("application.Recieve")); ?></th>
                  <th><?php echo e(__("application.Payment Due")); ?></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
                <tfoot1>
                  <tr id='footer-data'>
                    <td colspan="9" class="text-right"><?php echo e(__("application.Total")); ?></td>
                    <td id="sale-price"></td>
                    <td id="discount"></td>
                    <td id="sale-amount"></td>
                    <td id="recieve-amount"></td>
                    <td id="payment-due"></td>
                  </tr>
                </tfoot1>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  $(document).on("change","#project-id",function(){
    $.ajax({
      url:"<?php echo e(route('operation.get_payment')); ?>",
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"<?php echo e(csrf_token()); ?>",
        "request_type":"project",
        "project_id":$(this).val(),
        "category_id":$("category-id").val()
      },
      success:function(data){
        $("#item-id").empty();
        var opt = `<option value="">
                        Please Select
                     </option>`;
          $("#item-id").append(opt);
        $.each(data,function(index,val){
          var opt = `<option value="${val.id}">
                        ${val.name}
                     </option>`;
          $("#item-id").append(opt);
        });
      }
    });
  });
  $(document).ready(function() {
      $('.main-spinner').show();
       var sale_price;var discount_amount;var sale_amount;var payment_Recieve=0;
       var payment_due=0;
      $('#datable-payment').DataTable({
          "autoWidth": false,
          ordering: false,
          responsive: false,
          serverSide: true,
          "searching": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              },
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'print-report-id',
                      onclick:"print(this)"
                  }
              },
          ],
          ajax: {
            url:"<?php echo e(route('operation.get_payment')); ?>",
            type:"GET",
            data:function(d){
              var category_id = $("#category-id").val();
              var item_id = $("#item-id").val();
              var project_id = $("#project-id").val();
              var client_gender = $("#client-gender").val();
              var client_name = $("#client-name").val();
              var client_phone = $("#client-phone").val();
              var start_date = $("#start-date").val();
              var end_date = $("#end-date").val();
              d.category_id=category_id;
              d.item_id=item_id;
              d.project_id=project_id;
              d.client_gender=client_gender;
              d.client_name=client_name;
              d.client_phone=client_phone;
              d.start_date=start_date;
              d.end_date=end_date;
              d.last_months = $("#last_months").val();
            }
          },
          columns:
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'diburment_date','searchable': false},
              {data: 'item_name','name':'nso007_item_stock.name'},
              // {data: 'project_name','name':'nso007_project_stock.name'},
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'client_name','name':'nso007_client.name'},
              {data: 'client_phone','name':'nso007_client.phone'},
              {data: 'agency','searchable': false} ,
              {data:'percentage_paid','searchable': false},
              {data:'duration','searchable': false},
              {data:'sale_amount','searchable': false},
              {data:'discount_amount','searchable': false},
              {data:'sale_price','searchable': false},
              {data:'payment_Recieve','searchable': false},
              {data:'payment_due','searchable': false},
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
              // $("#datable-payment").append(`<tr id='footer-data'>
              //       <td colspan="10" class="text-right"><?php echo e(__("application.Total")); ?></td>
              //       <td id="Principle">$${sale_price}</td>
              //       <td id="Interest">$${discount_amount}</td>
              //       <td id="total-pay">$${sale_amount}</td>
              //       <td>$${payment_Recieve}</td>
              //       <td>$${payment_due}</td>
              //     </tr>`);
          },
          'footerCallback': function ( row, data, start, end, display ) {
            var api = this.api(), data;
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };


            sale_price = api
                .column( 9 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            discount_amount = api
                .column( 10 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            sale_amount = api
                .column( 11 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            payment_Recieve = api
                .column( 12 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            payment_due = api
                .column( 13 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            var currentcyFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$' ).display;
            $("#sale-price").html(currentcyFormat(sale_price));
            $("#discount").html(currentcyFormat(discount_amount));
            $("#sale-amount").html(currentcyFormat(sale_amount));
            $("#recieve-amount").html(currentcyFormat(payment_Recieve));
            $("#payment-due").html(currentcyFormat(payment_due));
        }
      });
      $.fn.dataTable.ext.errMode = 'throw';
  });
   $(document).on('click','#search-form',function(){
     $('#datable-payment').DataTable().draw(true);
   });

  function print(){
    var title=`Report Payment Payment`;
    var user_name = "<?php echo e(Auth::user()->name); ?>";
    var date = "<?php echo e(\Globals::date_khmers(date('d-m-Y'))); ?>";
    var table_data = $("#datable-payment").html();
    var project_name = "";
    let i = 0;
    $("select#project-id option").each(function(index,value){
      if($(this).prop("selected")==true){
        i++;
        project_name += $(this).text();
        if(i<$("#project-id option:selected").length) project_name += " និង ";
      }
    });
    let p_name = '';
    if(project_name!=''){
      p_name = '( គម្រោង៖ '+project_name+' )';
    }
    print_report_operation(title,table_data,user_name,date,p_name);// Refference at master page
  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/report/operation/payment.blade.php ENDPATH**/ ?>