<?php $__env->startSection("content"); ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Edit Journal</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active">Edit Journal</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <?php echo Form::model($journal[0], ['method' => 'PATCH','route' => ['journal.update', $journal[0]->id],'enctype'=>'multipart/form-data']); ?>

                        <div class="card card-default">
                            <div class="card-body">
                                <div class="row">
                                    <div class="form-group col-sm-6 col-xs-12" id="available-box">
                                        <label class="required">Date</label>
                                        <?php echo Form::text('journal_paydate', date('d-m-Y',strtotime($journal[0]->journal_paydate)), array('placeholder' => 'Date','class' => 'form-control date_picker','id' => 'date','required')); ?>

                                    </div>
                                    <div class="form-group col-sm-6 col-xs-12">
                                        <label class="required">Voucher Type</label>
                                        <?php echo Form::select('voucher_type',$voucher,$journal[0]->voucher_type,['class'=>'form-control select2','id'=>'voucher_type','required']); ?>

                                    </div>
                                    <div class="form-group col-sm-6 col-xs-12">
                                        <label for="required">Select Project</label>
                                        <?php echo Form::select('journal_by_project', $projects, null, ['class' => 'form-control select2','id'=>'project_id']); ?>

                                    </div>
                                    <div class="form-group col-sm-6 col-xs-12" id="available-box">
                                        <label class="required">Voucher Ref</label>
                                        <?php echo Form::text('voucher_ref', null, array('placeholder' => 'Voucher Ref','class' => 'form-control', 'id' => 'voucher_ref','readonly','required')); ?>

                                    </div>
                                    <div class="form-group col-sm-6 col-xs-12" id="available-box">
                                        <label class="">Description</label>
                                        <?php echo Form::textarea('journal_des', null, ['id' => 'description', 'rows' => 4, 'cols' => 54, 'class' => 'form-control']); ?>

                                    </div>
                                    <div class="col-sm-12 col-xs-12">
                                        <table class="table table-bordered table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th width="15%">Account Name</th>



                                                <th>Ref Number</th>
                                                <th>Debit</th>
                                                <th>Credit</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody id="tbody">
                                            <?php $__currentLoopData = $journal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $jn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo Form::select('acc_chart[]', $acc_chart, $jn->journal_acccode, ['class' => 'form-control select2 account_chart','required']); ?></td>



                                                    <td><input type="text" name="ref_number[]" value="<?php echo e($jn->journal_invoice); ?>" class="form-control" placeholder="Reference Number" required></td>
                                                    <td><input type="text" name="debit[]" value="<?php echo e($jn->journal_debit); ?>" class="form-control" placeholder="Debit" required></td>
                                                    <td><input type="text" name="credit[]" value="<?php echo e($jn->journal_credit); ?>" class="form-control" placeholder="Credit" required></td>
                                                    <td>
                                                        <input type="hidden" name="journal_id[]" value="<?php echo e($jn->id); ?>">
                                                        <?php if($i==1): ?>
                                                            <button type="button" class="btn btn-info btn-sm btn-add"><i class="fa fa-plus"></i></button>
                                                        <?php elseif($i>1): ?>
                                                            <button type="button" class="btn btn-danger btn-sm btn-remove"><i class="fa fa-trash"></i></button>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <div style="text-align: right;">
                                    <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> Save</button>
                                </div>
                            </div>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h3 class="modal-title text-danger">Warning...!</h3>
                </div>
                <br />
                <div class="row">
                    <div class="col-md-12">
                        <div class="col-md-10">
                            <h4>Receivable amount must be smaller than or equal available amount.</h4>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="button_primary"><i class="fa fa-close"></i> Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).on('click', '.btn-add', function() {
            //$('select').select2('destroy');
            $('#tbody').append(add_journal());
            $('.select2').select2({
                theme: 'bootstrap4'
            });
        });
        $(document).on('change', '.account_code', function() {
            var obj     = $(this).find(":selected").val();
            var element = $(this);
            if (obj    != "") {
                account_code(obj,element);
            }
            else{
                element.parent().next().find('.account_code').empty();
            }
        });
        $(document).on('click', '.btn-remove', function() {
            $(this).parent().parent().remove();
        });

        function account_code(obj,element) {
            var div = "";
            $('.main-spinner').show();
            $.ajax({
                url: "<?php echo e(route('search-account-code')); ?>",
                method: "POST",
                dataType: "json",
                data: {
                    obj: obj,
                    _token: '<?php echo e(csrf_token()); ?>',
                },
                success: function(data) {
                    $('.main-spinner').hide();
                    if(Object.keys(data).length){
                        element.parent().next().find('.account_code').empty().append(`<option value=""> Please Select </option>`);
                        $.each(data, function(index, value){
                            element.parent().next().find('.account_code').append($("<option></option>").attr("value",value.id).text(value.id +" | "+value.acc_name));
                        });
                    }
                    else{
                        element.parent().next().find('.account_code').empty();
                         element.parent().next().find('.account_code').empty().append(`<option value=""> Please Select </option>`);
                    }
                }
            });
        }

        function add_journal() {
            var tr = `<tr>
                   <td><?php echo Form::select('acc_chart[]', $acc_chart, null, ['class' => 'form-control select2 account_chart','required']); ?></td>
                    <td><input type="text" name="ref_number[]" class="form-control account" placeholder="Reference Number" required></td>
                    <td><input type="text" name="debit[]" value="0" class="form-control" placeholder="Debit" required></td>
                    <td><input type="text" name="credit[]" value="0" class="form-control" placeholder="Credit" required></td>
                    <td><button class="btn btn-danger btn-sm btn-remove"><i class="fa fa-trash"></i></button></td>
                </tr>`;
            return tr;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/accounting/journal/edit.blade.php ENDPATH**/ ?>