<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.Edit")); ?> <?php echo e(__("application.Item")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Manage POS Stock")); ?></li>
              <li class="breadcrumb-item"><a href="<?php echo e(route('item.index')); ?>"><?php echo e(__("application.Item")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Edit")); ?> <?php echo e(__("application.Item")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
    <?php echo Form::model($item, ['method' => 'PATCH','route' => ['item.update', $item->id]]); ?>

      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Category")); ?>:</strong>
                                    <?php echo Form::select('category_id',$categories,null, array('class' => 'form-control select2','required','id'=>'category-id')); ?>

                                </div>
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Block")); ?>:</strong>
                                    <?php echo Form::select('block_id',$blocks,null, array('class' => 'form-control select2','required','id'=>'display-block')); ?>

                                </div>
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Cost")); ?>:</strong>
                                    <?php echo Form::number('cost',null, array('placeholder' => __("application.Cost"),'class' => 'form-control','id'=>'item-cost')); ?>

                                </div>
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Price")); ?>:</strong>
                                    <?php echo Form::number('price', null, array('placeholder' => __("application.Price"),'class' => 'form-control','required','id'=>'item-price')); ?>

                                </div>
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Subcategory")); ?>:</strong>
                                    <?php echo Form::select('subcategory_id',$subcategories,null, array('class' => 'form-control select2','required','id'=>'subcategory-id')); ?>

                                </div>
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Group")); ?> <?php echo e(__('application.Item')); ?>:</strong>
                                    <?php echo Form::select('groupitem_id',$groupitems,null, array('class' => 'form-control select2','required','id'=>'groupitem-id')); ?>

                                </div>
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Item")); ?> <?php echo e(__("application.Name")); ?>:</strong>
                                    <?php echo Form::text('name', null, array('placeholder' =>__("application.Item").__("application.Name"),'class' => 'form-control','required','id'=>'item-name')); ?>

                                </div>
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Project")); ?>:</strong>
                                    <?php echo Form::select('project_id',$projects,null, array('class' => 'form-control select2','required','id'=>'project-id')); ?>

                                </div>
                                
                                <div class="form-group">
                                    <strong class="required"><?php echo e(__("application.Size")); ?>:(Ex:12mx16m)</strong>
                                    <?php echo Form::text('size', null, array('placeholder' =>__("application.Size"),'class' => 'form-control','required','id'=>'item-size')); ?>

                                </div>
                                
                                <div class="form-group">
                                    <strong><?php echo e(__("application.Description")); ?></strong>
                                    <?php echo Form::textarea('description', null, array('class' => 'form-control','placeholder'=>__("application.Description"),'rows'=>'3')); ?>

                                </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> <?php echo e(__("application.Back")); ?></button>
                            <button type="submit" class="btn btn-sm btn-success fa fa-save"> <?php echo e(__("application.Save")); ?> <?php echo e(__("application.Change")); ?></button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    <?php echo Form::close(); ?>

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="<?php echo e(asset('assets/js/location.js')); ?>"></script>
<script>
    $(document).on("change","#project-id",function () {
        var id = $(this).val();
        var route="<?php echo e(route("item.get_item")); ?>";
        $('.main-spinner').show();
        $.ajax({
            url:route,
            dataType:'JSON',
            type:"POST",
            data:{
                "_token":"<?php echo e(csrf_token()); ?>",
                "project_id":id
            },
            success:function(data){
                $('.main-spinner').hide();
                var opt="<option value=''>Please Select</option>";
                $.each(data,function(index,val){
                    opt+=`<option value="${val.id}">${val.name}</option>`;
                });
                $("#display-block").empty();
                $("#display-block").append(opt);
            },
            error:function(){
                console.log("NO");
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/item/edit.blade.php ENDPATH**/ ?>