@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>View And Edit User</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">User Management</li>
              <li class="breadcrumb-item"><a href="{{route('users.index')}}">User</a></li>
              <li class="breadcrumb-item active">Edit User</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            {!! Form::model($user, ['method' => 'PATCH','route' => ['users.update', $user->id]]) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">Name:</strong>
                                    {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>Phone:</strong>
                                     {!! Form::text('phone', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>ID Card:</strong>
                                    {!! Form::text('idcard', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                                </div>
                                <!-- /.form-group -->
                                <div class="form-group">
                                    <strong class="required">Email:</strong>
                                    {!! Form::text('email', null, array('placeholder' => 'Email','class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">Role:</strong>
                                    {!! Form::select('roles[]', $roles,$userRole, array('class' => 'form-control select2','required')) !!}
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">Gender:</strong>
                                    {!! Form::select('gender', ["Male"=>"Male","Female"=>"Female"],[], array('class' => 'form-control select2','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>Date of Birth:</strong>
                                    {!! Form::text('dob', null, array('class' => 'form-control date_picker','placeholder'=>'Date of Birth')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">Position:</strong>
                                    {!! Form::select('position', $position,null, array('class' => 'form-control select2','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>Password:</strong>
                                    {!! Form::password('password', array('placeholder' => 'Password','class' => 'form-control')) !!}
                                </div>
                                <!-- /.form-group -->
                                <div class="form-group">
                                    <strong>Confirm Password:</strong>
                                    {!! Form::password('confirm-password', array('placeholder' => 'Confirm Password','class' => 'form-control')) !!}
                                </div>
                            <!-- /.form-group -->
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <strong>Address</strong>
                                    {!! Form::textarea('address', null, array('class' => 'form-control','placeholder'=>'Address','rows'=>'3')) !!}
                                </div>
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer" style="text-align: right;">
                        <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> Back</button>
                        <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> Save Change</button>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
@endsection