@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.List")}} {{__("application.Supplier")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Supplier")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{route('suppliers.create')}}"> {{__("application.Create New")}}</a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-suppler" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Image")}}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Phone")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                  @foreach($suppliers as $key=>$value)
                    <tr>
                        <td>{{$key+1}}</td>
                        <td><img src="{{!empty($value->image)?asset('assets/img/upload'."/".$value->image):asset('assets/img/defaultphoto.png')}}" border="0" width="100px" height="80px" class="img-rounded" align="center" /></td>
                        <td>{{$value->supp_name}}</td>
                        <td>{{$value->supp_phone}}</td>
                        <td>{{$value->supp_des}}</td>
                        <td> <a href="{{Route("suppliers.edit", Crypt::encrypt($value->id))}}"  class="btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></a></td>
                    </tr>
                    <div class="modal fade" id="edit-form_{{$value->id}}">
                      <div class="modal-dialog modal-lg">
                        <form class="form-horizontal" role="form" action="{{route('suppliers.update')}}" method="post" name="cat">
                          @csrf
                        <div class="modal-content">
                          <div class="modal-header">
                            <h4 class="modal-title">Edit form</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          
                          <div class="modal-body">
                            <input type="hidden" name="id" id="id" value="{{$value->id}}">
                            <div class="form-group">
                                <strong class="required">{{__("application.Supplier")}} {{__("application.Name")}}:</strong>
                                <input type="text" name="supp_name" class="form-control  " id="name" value="{{$value->supp_name}}" placeholder="supplier name" required="true">
                            </div>
                            <div class="form-group">
                                <strong class="required">{{__("application.Phone")}}:</strong>
                                <input name="supp_phone" class="form-control  " id="des" placeholder="phone number" value="{{$value->supp_phone}}">
                            </div>
                            <div class="form-group">
                                <strong>{{__("application.Description")}}:</strong>
                                {!! Form::textarea('supp_des', $value->supp_des, array('placeholder' => __('application.Description'),'class' => 'form-control','rows'=>3)) !!}
                            </div>
                            <div class="form-group">
                                  <strong>{{__("application.Photo")}}</strong>
                                  <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo">
                                  <div style="width: 154px;height: 100px;">
                                      @if(!empty($value->image))
                                          <img src="{{asset('assets/img/upload/'.$value->image)}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                      @else
                                          <img src="{{asset('assets/img/defaultphoto.png')}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                      @endif
                                      
                                  </div>
                                  <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="RemoveImage()">{{__("application.Remove")}}</button>
                                  <label class="custom-file-upload">
                                      <input type="hidden" name="cpImage" value="{{$value->image}}" id="cpImage">
                                      <input type="file" id="file-image-ageny" name="image" onchange="previewImage(event)" />
                                      <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                  </label>
                              </div>
                          </div>
                          <div class="modal-footer justify-content-between">
                            <div>&nbsp;</div>
                            <button type="submit" class="btn btn-success btn-sm">{{__("application.Submit")}}</button>
                          </div>
                        </div>
                        </form>
                        <!-- /.modal-content -->
                      </div>
                      <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                  @endforeach
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript">
    function RemoveImage(){
      alert("OK");
        var imageField = document.getElementById("image-field");
        var resource = document.getElementById("default-photo");
        var imge = document.getElementById("file-image-ageny");
        imge.value="";
        imageField.src = resource.src;
        document.getElementById("cpImage").value="";
    }
    function previewImage(event){
        var reader = new FileReader();
        var imageField = document.getElementById("image-field");
        reader.onload = function(){
            if(reader.readyState == 2){
                imageField.src = reader.result;
            }
        }

        reader.readAsDataURL(event.target.files[0]);
    }
</script>
<script>  
  $(document).ready(function  () {
    $("#datable-suppler").DataTable({
      "scrollY": screen.height,
      "scrollX": true,
    });
  });
</script>
@endsection