@extends("layouts.master")
@section("content")
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__("application.Client")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage Client")}}</li>
               <li class="breadcrumb-item active">{{__("application.Client")}}</li>
              <li class="breadcrumb-item"><a href="{{route('client.index')}}">{{__("application.Show")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Edit")}} {{__("application.Client")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::open(['method' => 'POST','route' => ['suppliers.update'],'enctype' => 'multipart/form-data']) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                  <input type="hidden" name="id" id="id" value="{{$supplier->id}}">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Name")}}:</strong>
                                    {!! Form::text('supp_name',$supplier->supp_name, array('placeholder' => __("application.Name"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Phone")}}:</strong>
                                    {!! Form::text('supp_phone',$supplier->supp_phone, array('placeholder' => __("application.Phone"),'class' => 'form-control','required')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong>{{__("application.Photo")}}</strong>
                                    <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo">
                                    <div style="width: 154px;height: 100px;">
                                        @if(!empty($supplier->image))
                                            <img src="{{asset('assets/img/upload/'.$supplier->image)}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                        @else
                                            <img src="{{asset('assets/img/defaultphoto.png')}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                        @endif
                                        
                                    </div>
                                    <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="RemoveImage()">{{__("application.Remove")}}</button>
                                    <label class="custom-file-upload">
                                        <input type="hidden" name="cpImage" value="{{$supplier->image}}" id="cpImage">
                                        <input type="file" id="file-image-ageny" name="image" onchange="previewImage(event)" />
                                        <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                    </label>
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                
                                <div class="form-group">
                                <strong>{{__("application.Description")}}:</strong>
                                {!! Form::textarea('supp_des', $supplier->supp_des, array('placeholder' => __('application.Description'),'class' => 'form-control','rows'=>3)) !!}
                            </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript">
    function RemoveImage(){
        var imageField = document.getElementById("image-field");
        var resource = document.getElementById("default-photo");
        var imge = document.getElementById("file-image-ageny");
        imge.value="";
        imageField.src = resource.src;
        document.getElementById("cpImage").value="";
    }
    function previewImage(event){
        var reader = new FileReader();
        var imageField = document.getElementById("image-field");
        reader.onload = function(){
            if(reader.readyState == 2){
                imageField.src = reader.result;
            }
        }

        reader.readAsDataURL(event.target.files[0]);
    }
</script>
@endsection