@extends("layouts.master")
@section("content")
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.Create")}} {{__("application.Supplier")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Supplier")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::open(array('route' => 'suppliers.store','method'=>'POST','enctype' => 'multipart/form-data')) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Supplier")}} {{__("application.Name")}}:</strong>
                                    {!! Form::text('supp_name', null, array('placeholder' => __('application.Name'),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Phone")}}:</strong>
                                    {!! Form::text('supp_phone', null, array('placeholder' => __('application.Phone'),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Photo")}}</strong>
                                    <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo">
                                    <div style="width: 154px;height: 100px;">
                                        <img src="{{asset('assets\img\defaultphoto.png')}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                    </div>
                                    <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="RemoveImage()">{{__("application.Remove")}}</button>
                                    <label class="custom-file-upload">
                                        <input type="file" id="file-image-ageny" name="photo" onchange="previewImage(event)" />
                                        <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                    </label>
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong>{{__("application.Description")}}</strong>
                                    {!! Form::textarea('supp_des', null, array('placeholder' => __('application.Description'),'class' => 'form-control','rows'=>3)) !!}
                                </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection