@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Report")}} {{__("application.Item")}} {{__("application.Sold")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Report")}} {{__("application.Item")}} {{__("application.Sold")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @include("report.report-stock.item-sold-form-search",compact("categories","projects","items"))
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-item" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Item")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Category")}} {{__("application.Name")}}</th>
                  {{-- <th>{{__("application.Project")}} {{__("application.Name")}}</th> --}}
                  <th>{{__("application.Size")}}</th>
                    <th>{{__("application.Status")}}</th>
                  <th>{{__("application.Cost")}}($)</th>
                  <th>{{__("application.Price")}}($)</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
                <tfoot1>
                  <tr id='footer-data'>
                      <td colspan="5" class="text-right">{{__("application.Total")}}&nbsp;</td>
                      <td id="Cost"></td>
                      <td id="Price"></td>
                  </tr>
                </tfoot1>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  $(document).on("change","#project-id",function(){
    $.ajax({
      url:"{{ route('item_sold_report.get_sold_item') }}",
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"{{csrf_token()}}",
        "request_type":"project",
        "project_id":$(this).val(),
        "category_id":$("category-id").val()
      },
      success:function(data){
        $("#item-id").empty();
        var opt = `<option value="">
                        Please Select
                     </option>`;
          $("#item-id").append(opt);
        $.each(data,function(index,val){
          var opt = `<option value="${val.id}">
                        ${val.name}
                     </option>`;
          $("#item-id").append(opt);
        });
      },
      error:function(data){
        $('.main-spinner').hide();
      }
    });
  });
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datable-item').DataTable({
          "autoWidth": false,
          ordering: false,
          serverSide: true,
          responsive:false,
          "searching": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              },
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'print-report-id',
                      onclick:"print(this)"
                  }
              },
          ],
          ajax: {
            url:"{{ route('item_sold_report.get_sold_item') }}",
            type:"GET",
            data:function(d){
              var category_id = $("#category-id").val();
              var item_id = $("#item-id").val();
              var item_price = $("#item-price").val();
              var project_id = $("#project-id").val();
              var item_cost = $("#item-cost").val();
              var item_size = $("#item-size").val();

              d.category_id=category_id;
              d.item_id=item_id;
              d.item_price=item_price;
              d.project_id=project_id;
              d.item_cost=item_cost;
              d.item_size=item_size;
              d.block_id = $("#display-block").val();
                d.item_status=$("#item-status").val();
            }
          },
          columns:
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'name','name':'nso007_item_stock.name'},

              {data: 'category_name','name':'nso007_category_stock.name'},
              // {data: 'project_name','name':'nso007_project_stock.name'},
              {data: 'size','name':'nso007_item_stock.size'} ,
              {data:'status','searchable': false},
              {data: 'cost','name':'nso007_item_stock.cost'},
              {data: 'price','name':'nso007_item_stock.price'},
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          },
          'footerCallback': function ( row, data, start, end, display ) {
              var api = this.api(), data;
              var intVal = function ( i ) {
                  return typeof i === 'string' ?
                      i.replace(/[\$,]/g, '')*1 :
                      typeof i === 'number' ?
                          i : 0;
              };


              Cost = api
                  .column( 5 )
                  .data()
                  .reduce( function (a, b) {
                      return intVal(a) + intVal(b);
                  }, 0 );

              Price = api
                  .column( 6 )
                  .data()
                  .reduce( function (a, b) {
                      return intVal(a) + intVal(b);
                  }, 0 );
              var currentcyFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$' ).display;
              $("#Cost").html(currentcyFormat(Cost));
              $("#Price").html(currentcyFormat(Price));
          }
      });
      $('#search-form').on('click', function(){
        $('#datable-item').DataTable().draw(true);
      });
      $.fn.dataTable.ext.errMode = 'throw';
  });
  $(document).on("change","#project-id",function () {
      var id = $(this).val();
      var route="{{route('item_report.get_all_item')}}";
      $('.main-spinner').show();
      $.ajax({
          url:route,
          dataType:'JSON',
          type:"POST",
          data:{
              "_token":"{{csrf_token()}}",
              "project_id":id,
              "request_type":"get-block"
          },
          success:function(data){
              block_item = data;
              $('.main-spinner').hide();
              var opt="<option value=''>Please Select</option>";
              $.each(data,function(index,val){
                  opt+=`<option value="${val.id}">${val.name}</option>`;
              });
              $("#display-block").empty();
              $("#display-block").append(opt);
          },
          error:function(){
              console.log("NO");
              $('.main-spinner').hide();
          }
      });
  });
  function print(){
    var title=`Report Sold Item`;
    var user_name = "{{Auth::user()->name}}";
    var date = "{{\Globals::date_khmers(date('d-m-Y'))}}";
    var table_data = $("#datable-item").html();
    var project_name = "";
    let i = 0;
    $("select#project-id option").each(function(index,value){
    if($(this).prop("selected")==true){
        i++;
        project_name += $(this).text();
        if(i<$("#project-id option:selected").length) project_name += " និង ";
    }
    });
    let p_name = '';
    if(project_name!=''){
    p_name = '( គម្រោង៖ '+project_name+' )';
    }
    print_report(title,table_data,user_name,date,p_name);// Refference at master page
  }
</script>
@endsection
