@extends("layouts.master")
@section("content")
@include('position.create')
@include('position.show')
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Position List")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.User Management")}}</li>
              <li class="breadcrumb-item active">{{__("application.Position")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              @can('Position-Create')
              <div class="pull-left">
                <!-- <a class="btn btn-sm btn-success" href="{{ route('position.create') }}"> Create New</a> -->
                <button type="button" class="btn btn-success btn-md" data-toggle="modal" data-target="#modal-lg">
                  {{__("application.Create New")}}
                </button>
              </div>
              @endcan
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-user" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                   @foreach ($data as $key => $row)
                    <tr>
                      <td>{{ ++$key }}</td>
                      <td>{{ $row->name }}</td>
                      <td>{{ $row->description }}</td>
                      <td>
                         <a class="btn btn-sm btn-success" title="View and Edit" title-position="{{$row->name}}" des="{{$row->description}}" onclick="show_position(this,'{{$row->id}}')"><i class="fa fa-eye"></i></a>
                         @can('Position-Delete')
                          <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#modal-danger{{$row->id}}">
                          <i class="fa fa-trash" title="Delete"></i>
                          </button>
                        @endcan
                          {!! Form::open(['method' => 'DELETE','route' => ['position.destroy', $row->id],'style'=>'display:inline']) !!}
                            <div class="modal fade" id="modal-danger{{$row->id}}">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">{{__("application.Delete")}} {{__("application.Position")}}</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">{{__("application.Are you sure want to delete this")}} ?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> {{__("application.OK")}}</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                          {!! Form::close() !!}
                      </td>
                    </tr>
                   @endforeach
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  $(document).ready(function(){
    $("#datable-user").DataTable();
  });
  function show_position(obj,id){
    var title = $(obj).attr("title-position");
    var des = $(obj).attr("des");
    $("#position-title-show").val(title);
    if(des!=null || des!="") $("#position-description-show").val(des);
    $("#position-id-show").val(id);
    $("#modal-lg-show").modal("show");
  }
  $(document).on("click","#position-save-change",function(){
    var title = "";
    var description="";
    var ID="";
    title = $("#position-title-show").val();
    description = $("#position-description-show").val();
    ID=$("#position-id-show").val();
    if(ID==""||ID==null){
      toastr.error("Erro with your data !");
    }
    else if(title=="" || title==null){
      $("#position-title-show").css("border-color","red");
      $("#position-title-show").focus();
    }else{
      $('.main-spinner').show();
      $.ajax({
        dataType:'json',
        url:"{{route('position.update-position')}}",
        type:"POST",
        data:{
          "_token":"{{csrf_token()}}",
          "title":title,
          "description":description,
          'id':ID
        },
        success:function(data){
          $('.main-spinner').hide();
          window.location.reload();
          toastr.success("Update successfully !");
        },
        error:function(data){
          toastr.error("Erro with your input !");
        }
      });
    }
  });
  $(document).on("click","#position-save",function(){
    var title = "";
    var description="";
    title = $("#position-title").val();
    description = $("#position-description").val();
    if(title=="" || title==null){
      $("#position-title").css("border-color","red");
      $("#position-title").focus();
    }else{
      $('.main-spinner').show();
      $.ajax({
        dataType:'json',
        url:"{{route('position.store')}}",
        type:"POST",
        data:{
          "_token":"{{csrf_token()}}",
          "title":title,
          "description":description
        },
        success:function(data){
          $('.main-spinner').hide();
          $("#modal-lg").modal("hide");
          window.location.reload();
          toastr.success("Create successfully !");
        },
        error:function(data){
          toastr.error("Erro with your input !");
        }
      });
    }
  });
</script>
@endsection