@extends("layouts.master")
@section("content")
@include("pos.deposit")
@include("pos.create-new-client",compact('provinces'))
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
    ul.list-group{
      position: absolute;
      z-index: 100000000000;
      width: 94%;
    }
    li.list-group-item:hover{
      background-color: #4CAF50;
      color: white;
      /*font-size: 16px;*/
      border: none;
      cursor: pointer;
      width: 100% !important;
    }
    .jconfirm {
      z-index: 1;
    }
</style>
<!-- Content Wrapper. Contains page content -->

  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-8">
            <h1 style="float: left;">{{__("application.POS")}}</h1>
            <div style="text-align:right;">
              <a href="#create-new-client" class="btn btn-sm btn-success" data-toggle="modal">New Client</a>
            </div>
          </div>
          <div class="col-sm-4">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.POS Operation")}}</li>
              <li class="breadcrumb-item active">{{__("application.POS")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Info boxes -->
        <!-- /.row -->
        <!-- Main row -->
        <div class="row">
          <!-- Left col -->
          <div class="col-md-8">
            <!-- TABLE: LATEST ORDERS -->
            <div class="card">
              <div class="card-header" id="card-search-pos" style ="display:none;">
                  <h4>{{__("application.Filtering")}}</h4>
                  <div class="pull-left">
                      <div class="row">
                          <div class="col-md-6">
                              <div class="form-group">
                                  <strong>{{__("application.Project")}}:</strong>
                                  {!! Form::select('project',$projects,null, array('class' => 'form-control select2','id'=>'project-id')) !!}
                              </div>
                          </div>
                          <div class="col-md-6">
                              <div class="form-group">
                                  <strong>{{__("application.Block")}}:</strong>
                                  {!! Form::select('block',[],null, array('class' => 'form-control select2','id'=>'display-block')) !!}
                              </div>
                          </div>
                      </div>
                      <div class="row">
                        <div class="col-md-6">
                          <div class="form-group">
                              <strong>{{__("application.Item")}} {{__("application.Name")}}:</strong>
                              {!! Form::text('item_name',null, array('class' => 'form-control','id'=>'item-name')) !!}
                          </div>
                        </div>
                      </div>
                      <div class="col-md-6">
                          <button class="btn btn-success btn-sm" id="search-form">{{__("application.Search")}}</button>
                      </div>
                  </div>
              </div>
              <div class="card-header border-transparent">
                <h3 class="card-title">{{__("application.Item")}} {{__("application.For")}} {{__("application.Order")}}</h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse" id = "item-order-minus">
                    <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" disabled class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body" id="body-list-item-order">
                <div class="table-responsive">
                  <table class="table m-0" id="pos-item">
                    <thead>
                    <tr>
                      <th>{{__("application.No")}}</th>
                      <th>{{__("application.Item")}}</th>
                      <th>{{__("application.Block")}}</th>
                      <th>{{__("application.Price")}}</th>
                      <th>{{__("application.Category")}}</th>
                      <th>{{__("application.Project")}}</th>
                      <th>{{__("application.Action")}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
                <!-- /.table-responsive -->
              </div>
              <!-- /.card-body -->
              <!-- <div class="card-footer clearfix">
                <a href="javascript:void(0)" class="btn btn-sm btn-info float-left">Place New Order</a>
                <a href="javascript:void(0)" class="btn btn-sm btn-secondary float-right">View All Orders</a>
              </div> -->
              <!-- /.card-footer -->
            </div>
            <!-- /.card -->
            <div class="card">
              <div class="card-header border-transparent">
                <h3 class="card-title">{{__("application.Deposit")}} {{__("application.Information")}}</h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse" id = "deposit-information-minus">
                    <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" disabled class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body" id="deposit-information">
                {!! Form::open(array('route' => 'pos.store','method'=>'POST','enctype' => 'multipart/form-data')) !!}
                @csrf
                  <div class="modal-body">
                    <!-- /.card-header -->
                      <div class="">
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <strong class="required">{{__("application.Client")}}:</strong>
                              {!! Form::select('client_id',$clients,null, array('class' => 'form-control select2','id'=>'client-id','required')) !!}
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <strong>{{__("application.Sale")}} {{__("application.Agent")}}:</strong>
                              {!! Form::select('agency_id',$agencies, null, array('class' => 'form-control select2')) !!}
                            </div>
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <strong >{{__("application.Deposit")}} {{__("application.Date")}}:</strong>
                              {!! Form::text('date', date("d-m-Y"), array('class' => 'form-control date_picker','placeholder'=>__("application.Date"))) !!}
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <strong class="required">{{__("application.Contract")}} {{__("application.Date")}}:</strong>
                              {!! Form::text('contract_date', date("d-m-Y"), array('class' => 'form-control date_picker','placeholder'=>__("application.Contract")." ".__("application.Date"),'required')) !!}
                            </div>
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <strong>{{__("application.Policy")}} {{__("application.Payment")}}:</strong>
                              {!! Form::select('policy_payment',$policy_payments,null, array('class' => 'form-control select2')) !!}
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <strong>{{__("application.Policy")}} {{__("application.Payment")}} {{__("application.Detail")}}:</strong>
                              {!! Form::select('policy_payment_detail', [],null, array('class' => 'form-control select2')) !!}
                            </div>
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <strong class="required">{{__("application.Discount")}} {{__("application.Amount")}}:</strong>
                              {!! Form::number('discount_amount', 0, array('placeholder' =>__("application.Discount"),'class' => 'form-control','step'=>'any','required')) !!}
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <strong class="required">{{__("application.Discount")}} {{__("application.Percentage")}}:</strong>
                              {!! Form::number('discount_percentage', 0, array('placeholder' =>"%",'class' => 'form-control','step'=>'any','required')) !!}
                            </div>
                          </div>
                        </div>
                          <!-- /.row -->
                          <div class="row">
                            <div class="col-md-12">
                                 <!-- /.card-header -->
                                <div class="card-body p-0" id="generate-step-loan">
                                    <div class="table-responsive">
                                        <h5>Deposit Schedule</h5>
                                        <table class="table m-0">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Amount($)</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tb-step-generate">

                                                <tr>
                                                    <td>
                                                        <input type="text" class="form-control payment-date-tr date_picker" name="date_payment[]" placeholder="Date" id="date-1" value="{{ date('d-m-Y') }}" required>
                                                    </td>
                                                    <td>
                                                        <input type="number" class="form-control nso-amount-input-step" name="payment_amount[]" 
                                                        placeholder="Amount" onkeyup="input_amount(this)" onchange="input_amount(this)" step="any" value="0" required>
                                                    </td>
                                                    <td>
                                                        <button type="button" disabled class="btn btn-md btn-danger" onclick="Remove_row(this)">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- /.table-responsive -->
                                </div>
                              <!-- /.card-body -->
                              <!-- /.card-footer -->
                            </div>
                          </div>
                      </div>
                    <!-- /.card-body -->
                      <div class="modal-footer">
                          <div style="text-align: right;">
                              <button type="button" class="btn btn-sm btn-info" id="add-step"><i class="fas fa-plus"></i> Add Step</button>
                              <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                          </div>
                      </div>
                  </div>
              <!-- /.card -->
              {!! Form::close() !!}
              </div>
            </div>
          </div>
          <!-- /.col -->

          <div class="col-md-4">
            <!-- PRODUCT LIST -->
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">{{__("application.Recently")}} {{__("application.Added")}} {{__("application.Item")}}</h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" disabled class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body p-0">
                <ul class="products-list product-list-in-card pl-2 pr-2" id="order-list">
                  @if(session()->has("Cart"))
                    @foreach(session()->get("Cart") as $key => $value)
                      <li class="item" id="item-order-{{$value['id']}}">
                        <div class="product-info" style="margin-left: 25px;">
                          <a href="javascript:void(0)" class="product-title">{{$value['name']}}
                            <span class="badge badge-warning float-right cart-list-item-price" data-item_price = "{{$value['price']}}">${{$value['price']}}</span></a>
                          <span class="product-description">
                            {{__("application.Project")}} : {{$value['project_name']}}, Size : {{$value['size']}}
                          </span>
                        </div>
                      </li>
                    @endforeach
                  @endif
                </ul>
              </div>
              <!-- /.card-body -->
              @can('POS-Deposit')
              <a href="javascript:void(0)" style="float:left;border-top:1px solid rgb(224,224,224);" id="btn-add-back" class="btn btn-sm" title="Back">
                {{__("application.Back")}}
              </a>
              <a href="javascript:void(0)" id="btn-add-next" style="border-top:1px solid rgb(224,224,224);" class="btn btn-sm" title="Next">
                {{__("application.Next")}}
              </a>
              @endcan
              <!-- /.card-footer -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        
      </div><!--/. container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')

<script>
  $(document).on("change","select[name=policy_payment]",function(){
    if($(this).find("option:selected").val()==""){}
    else{
      $(".main-spinnter").show();
      $.ajax({
        url:"{{route('get_payment_policy_detail')}}",
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"{{csrf_token()}}",
          "payment_policy_id":$(this).find("option:selected").val()
        },
        success:function(data){
          var opt = "<option value=''>Please Select</option>";
          $.each(data,function(index,value){
            opt += `<option value= '${value.id}'>${value.name}</option>`;
          });
          $("select[name=policy_payment_detail]").html(opt);
        },
        error:function(){
          toastr.warning("Error with your request !");
        },
        complete:function(){
          $(".main-spinnter").hide();
        }
      });
    }
  });
  function Remove_row(obj){
    $(obj).closest("tr").remove();
  }
  $(document).on("click","#add-step",function () {
      var tr_append = $("tbody#tb-step-generate tr");
      var index=1;
      if(tr_append.length>=1){
        index=tr_append.length+1;
        var disburment_date = $(".payment-date-tr").last().val();
        var str = disburment_date.split("-");
        var day = str[0];var month = str[1];var year = str[2];
        var date_append = year+'-'+month+'-'+day;
        var date = new Date(date_append);
            date.setMonth(date.getMonth() + 1);
            console.log("first:"+date);
      }
      
      var tr=`<tr>
                  <td><input type="text" class="form-control date_picker payment-date-tr" name="date_payment[]" required
                      placeholder="Date Payment" id="date-${index}" required></td>
                  <td>
                    <input type="number" class="form-control nso-amount-input-step" name="payment_amount[]" 
                    placeholder="Amount" required step="any" value="0">
                  </td>
                  <td>
                    <button type="button" class="btn btn-md btn-danger" onclick="Remove_row(this)">
                      <i class="fas fa-trash"></i>
                    </button>
                  </td>
                </tr>`;
      $("tbody#tb-step-generate").append(tr);
      $("input#date-"+index).datepicker({dateFormat:"dd-mm-yy",changeMonth: true,
            changeYear: true}).datepicker("setDate",date);

        if(tr_append.length>=1){
            index=tr_append.length+1;
            var disburment_date = $(".payment-date-tr").last().val();
            var str = disburment_date.split("-");
            var day = str[0];var month = str[1];var year = str[2];
            var date_append = year+'-'+month+'-'+day;
            var date = new Date(date_append);
            date.setMonth(date.getMonth() + 1);
        }
        increment_z_index_datepicker();
    });
  function increment_z_index_datepicker(){
      $(document).on("click",".date_picker",function(){
          $(this).css("position","relative");
          $(this).css("z-index",10000000);
      });
      $(document).on("change",".date_picker",function(){
          $(this).css("position","relative");
          $(this).css("z-index",1);
      });
      //click on body > div have this ID
      $(document).on("click","#content-wrapper-id",function(){
          $(this).css("position","relative");
          $(this).css("z-index",1);
      });
  }
  $(document).ready(function(){
    $("#deposit-information").hide();
    increment_z_index_datepicker();
  });
  $(document).on("click","#btn-add-next",function(){
    $("#body-list-item-order").hide();
    $("#item-order-minus").html(`<i class="fas fa-plus"></i>`);

    $("#deposit-information").show();
    $("#deposit-information-minus").html(`<i class="fas fa-minus"></i>`);
    increment_z_index_datepicker();
  });
  $(document).on("click","#btn-add-back",function(){
    $("#body-list-item-order").show();
    $("#item-order-minus").html(`<i class="fas fa-minus"></i>`);

    $("#deposit-information").hide();
    $("#deposit-information-minus").html(`<i class="fas fa-plus"></i>`);
  });
  $(document).on('click','#search-form',function(){
    $('#pos-item').DataTable().draw(true);
  });
  $(document).on("submit","#form-deposit",function(e){

    var checkInner=$("#order-list li");
    if(checkInner.length<=0){
      e.preventDefault();
      toastr.warning("Please add item to cart !");
    }else{
      $("#form-deposit").submit();
    }
  });
  function Add_To_Cart(obj){

    if($(obj).closest("tr").hasClass("child")){
      var id = $(obj).closest("tr").prev().attr("id");
    }else{
      var id = $(obj).closest("tr").attr("id");
    }

    if(id==""){
      toastr.warning("Error with your request. Please try again !");
    }else{
      $('.main-spinner').show();
      var route="{{route('pos.Add_To_Cart')}}";
      $.ajax({
        type:"post",
        dataType:"JSON",
        url:route,
        data:{
          "_token":"{{csrf_token()}}",
          "id":id
        },
        success:function(message){
          $('.main-spinner').hide();
          if(message.type=="error"){
            toastr.error(message.text);
          }else if(message.type=="exist"){
            toastr.warning(message.text);
          }else if(message.type=="added"){
            toastr.success(message.text);
            var opt="";
            $("#order-list").empty();
            $.each(message.data,function(index,val){
              opt+=`<li class="item" id="item-order-${val.id}">
                    <div class="product-info" style="margin-left: 25px;">
                      <a href="javascript:void(0)" class="product-title">${val.name}
                        <span class="badge badge-warning float-right cart-list-item-price" data-item_price = "${val.price}">$${val.price}</span></a>
                      <span class="product-description">
                        Project : ${val.project_name}, Size : ${val.size}
                      </span>
                    </div>
                  </li>`;
            });
            $("#order-list").append(opt);
            $(obj).closest("td").append(`<button type="button" class="btn btn-info btn-sm" title="Undo ( Remove Item From Cart)" onclick="Remove_From_Cart(this)"><i class="fas fa-undo-alt"></i></button>`);
            $(obj).remove()
          }else{

          }
          $('input[name=discount_percentage]').change();
        },
        error:function(){
          toastr.error("Error with your request. Please try again !");
        }
      });
    }
  }
  function Remove_From_Cart(obj){

    if($(obj).closest("tr").hasClass("child")){
      var id=$(obj).closest("tr").prev().attr("id");
    }else{
      var id=$(obj).closest("tr").attr("id");
    }
    $('.main-spinner').show();
    var route="{{route('pos.Remove_From_Cart')}}";
    $.ajax({
      url:route,
      dataType:"JSON",
      type:"POST",
      data:{
        "_token":"{{csrf_token()}}",
        "id":id
      },
      success:function(message){
        $('.main-spinner').hide();
        if(message=="Error"){
          toastr.error("Error with your request. Please try again !");
        }
        else{
          $("#item-order-"+id).remove();
          $(obj).closest("td").append(`<button type="button" class="btn btn-success btn-sm" data-index="${id}" title="Add To Cart" onclick="Add_To_Cart(this)"><i class="fas fa-cart-arrow-down"></i></button>`);
          $(obj).remove()
          $('input[name=discount_percentage]').change();
          toastr.success("Remove from cart successfully !");
        }
      },
      error:function(){
        toastr.error("Error with your request. Please try again !");
      }
    });
  }
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#pos-item').DataTable({
          "autoWidth": false,
          ordering: false,
          serverSide: true,
          lengthMenu: [[10,20, 30, 50, 100,200,500,1000], [10,20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search-pos',
                      onclick:"search_pos(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              }
          ],
          ajax: {
            url:"{{ route('pos.get_item') }}",
            type:"GET",
            data:function(d){
              var project_id = $("#project-id").val();
              var block_id = $("#display-block").val();
              d.project_id = project_id;
              d.block_id = block_id;
              d.item_name = $("#item-name").val();
            }
          },
          columns:
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'name','name':'nso007_item_stock.name'},
              {data: 'block','searchable': false},
              {data: 'price','name':'nso007_item_stock.price'},
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'project_name','name':'nso007_project_stock.name'},
              {data: 'action','searchable': false},
          ],

          "initComplete": function(settings, json) {
            $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });
  function search_pos(obj){
    $("#card-search-pos").toggle(500);
  }
  $(document).on("change","#project-id",function () {
        var id = $(this).val();
        var route="{{route("item.get_item")}}";
        $('.main-spinner').show();
        $.ajax({
            url:route,
            dataType:'JSON',
            type:"POST",
            data:{
                "_token":"{{csrf_token()}}",
                "project_id":id
            },
            success:function(data){
                block_item = data;
                $('.main-spinner').hide();
                var opt="<option value=''>Please Select</option>";
                $.each(data,function(index,val){
                    opt+=`<option value="${val.id}">${val.name}</option>`;
                });
                $("#display-block").empty();
                $("#display-block").append(opt);
            },
            error:function(){
                console.log("NO");
            }
        });
    });
  $(document).on("click","#btn-add-deposit",function(){
    $("#item-order-minus").click();
  });
  $(document).on("click","#btn-add-deposit-",function(){
    $.confirm({
      title: '<br/>Deposit Information!',
      content: `
      <form action="{{route('pos.store')}}" method="POST" id="deposit-form-id" class="formName m-2">
        <div class="row">
          <div class="form-group col-6">
            <strong class="required">{{__("application.Client")}}(<a href="#" id="btn-create-client">create new</a>):</strong>
             <div>
              {!! Form::text('client_id',null, array('class' => 'form-control client_id','required','id'=>'client-search','autocomplete'=>'off','placeholder'=>"Name")) !!}
              <select name="client" class="client form-control" style="display:none;" id="appended-client"></select>

              <ul class="list-group" id="append-client">
              </ul>
             </div>
          </div>
          <div class="form-group col-6">
              <strong class="required">{{__("application.Date")}}:</strong>
              {!! Form::text('date', date("d-m-Y"), array('placeholder' => __("application.Date"),'class' => 'form-control date_picker date-deposit','required')) !!}
          </div>
        </div>
        <div class="row">
          <div class="form-group col-6">
              <strong class="required">{{__("application.Date")}} {{__("application.Contract")}}:</strong>
              {!! Form::text('contract_date', date("d-m-Y"), array('placeholder' =>__("application.Date"),'class' => 'form-control date_picker contract_date','required')) !!}
          </div>
          <div class="form-group col-6">
                <strong class="required">{{__("application.Amount")}}($):</strong>
                {!! Form::number('deposit_amount',null, array('placeholder' => __("application.Amount"),'class' => 'form-control deposit_amount','required')) !!}
          </div>
        </div>
        <div class="row">
          <div class="form-group col-6">
              <strong class="required">{{__("application.Agency")}}:</strong>
              {!! Form::text('agency',null, array('class' => 'form-control agency','required','id'=>'agency-search','autocomplete'=>'off','placeholder'=>"Name")) !!}
              <select name="agency" class="agency-id form-control" style="display:none;" id="appended-agency"></select>

            <ul class="list-group" id="append-agency">
            </ul>
          </div>
          <div class="form-group col-6">
              <strong>{{__("application.Accountant")}}:</strong>
              {!! Form::text('accountant_name',null, array('placeholder' => __("application.Accountant")." ".__("application.Name"),'class' => 'form-control accountant_name')) !!}
          </div>
        </div>
        <div class="row">
          <div class="form-group col-12">
              <label class="required">{{__('application.Payment Method')}}</label>
              {!! Form::select('bank_list', $banklist, null, ['class' => 'form-control bank_list','id'=>'bank_list','required']) !!}
          </div>
        </div>
        <div class="row" style="display:none;">
          <div class="form-group col-12">
              <strong>{{__("application.Description")}}</strong>
              {!! Form::textarea('description', null, array('class' => 'form-control description','placeholder'=>__("application.Description"),'rows'=>'2')) !!}
          </div>
        </div>
      </form>`,
      columnClass: 'col-md-4 col-md-offset-8 col-xs-4 col-xs-offset-8',
      containerFluid: false,
      buttons: {
          formSubmit: {
              text: 'Submit',
              btnClass: 'btn-blue',
              action: function () {
                  var client_id = this.$content.find('.client').val();
                  var agency_id = this.$content.find('.agency-id').val();
                  var date_deposit = this.$content.find('.date-deposit').val();
                  var contract_date = this.$content.find('.contract_date').val();
                  var deposit_amount = this.$content.find('.deposit_amount').val();
                  var accountant_name = this.$content.find('.accountant_name').val();
                  var description = this.$content.find('.description').val();
                  var bank_list = this.$content.find(".bank_list").val();
                  if(!client_id){
                    $.alert('provide a valid Client Name');
                    return false;
                  }
                  if(!agency_id){
                    $.alert('provide a valid Agency Name');
                    return false;
                  }
                  if(!date_deposit){
                    $.alert('provide a valid Deposit Date');
                    return false;
                  }
                  if(!contract_date){
                    $.alert('provide a valid Contract Date');
                    return false;
                  }
                  if(!deposit_amount){
                    $.alert('provide a valid Deposit Amount');
                    return false;
                  }
                  if(!bank_list){
                    $.alert("provide a valide Payment Method");
                    return false;
                  }
                  $.ajax({
                    url: '{{route("pos.store")}}',
                    type: 'POST',
                    dataType: 'JSON',
                    data: {
                      client_id: client_id,
                      agency_id: agency_id,
                      date     : date_deposit,
                      contract_date:contract_date,
                      deposit_amount:deposit_amount,
                      accountant_name:accountant_name,
                      description:description,
                      "_token":"{{csrf_token()}}",
                      bank_list:bank_list
                    },
                  })
                  .done(function(data) {
                    if(data=="OK"){
                      window.location.href="{{route('deposit.index')}}";
                    }
                    else if(data=="BOOKED"){
                      toastr.warning("Some item is booked. Please try again !");
                    }
                    else if(data="Error-Deposit-Amount"){
                      toastr.error("Amount deposit must be less than 20% of Sale Price. Please try again !");
                    }
                    else{
                      toastr.error("Error with your request. Please try again !");
                    }
                    console.log("success");
                  })
                  .fail(function() {
                    console.log("error");
                    toastr.error("Error with your request. Please try again !");
                  })
                  .always(function() {
                    console.log("complete");
                  });

              }
          },
          cancel: function () {
              //close
          },
      },
      onContentReady: function () {
          // bind to events
          var jc = this;
          this.$content.find('form').on('submit', function (e) {
              // if the user submits the form by pressing enter in the field.
              e.preventDefault();
              jc.$$formSubmit.trigger('click'); // reference the button and click it
          });
      }
    });
    $(document).on("focus","#client-search",function(){
      $(".main-spinner").show();
      $("#append-client").empty();
      $.ajax({
        url: '{{route("get-client-search")}}',
        type: 'POST',
        dataType: 'JSON',
        data: {
          client_name: $("#client-search").val(),
          "_token":"{{csrf_token()}}"
        },
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#append-client").empty();
        var opt="";
        $.each(data,function(index, val) {
          opt+=
              `
                <li class="list-group-item" data-id="${val.id}" onclick="select_client(this)">${val.name}</li>
              `;

        });
        $("#appended-client").empty();
        $("#appended-client").append(`<option value="${data[0].id}" selected>${data[0].name}</option>`);
        $("#append-client").append(opt);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
    });
    $(document).on("keyup","#client-search",function(){
      $(".main-spinner").show();
      $("#append-client").empty();
      $.ajax({
        url: '{{route("get-client-search")}}',
        type: 'POST',
        dataType: 'JSON',
        data: {
          client_name: $("#client-search").val(),
          "_token":"{{csrf_token()}}"
        },
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#append-client").empty();
        var opt="";
        $.each(data,function(index, val) {
          opt+=
              `
                <li class="list-group-item" data-id="${val.id}" onclick="select_client(this)">${val.name}</li>
              `;

        });
        $("#appended-client").empty();
        $("#appended-client").append(`<option value="${data[0].id}" selected>${data[0].name}</option>`);
        $("#append-client").append(opt);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
    });
    $(document).on("focus","#agency-search",function(){
      $(".main-spinner").show();
      $("#append-agency").empty();
      $.ajax({
        url: '{{route("get-agency-search")}}',
        type: 'POST',
        dataType: 'JSON',
        data: {
          agency_name: $("#agency-search").val(),
          "_token":"{{csrf_token()}}"
        },
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#append-agency").empty();
        var opt="";
        $.each(data,function(index, val) {
          opt+=
              `
                <li class="list-group-item" data-id="${val.id}" onclick="select_agency(this)">${val.name}</li>
              `;

        });
        $("#appended-agency").empty();
        $("#appended-agency").append(`<option value="${data[0].id}" selected>${data[0].name}</option>`);
        $("#append-agency").append(opt);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
    });
    $(document).on("keyup","#agency-search",function(){
      $(".main-spinner").show();
      $("#append-agency").empty();
      $.ajax({
        url: '{{route("get-agency-search")}}',
        type: 'POST',
        dataType: 'JSON',
        data: {
          agency_name: $("#agency-search").val(),
          "_token":"{{csrf_token()}}"
        },
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#append-agency").empty();
        var opt="";
        $.each(data,function(index, val) {
          opt+=
              `
                <li class="list-group-item" data-id="${val.id}" onclick="select_agency(this)">${val.name}</li>
              `;

        });
        $("#appended-agency").empty();
        $("#appended-agency").append(`<option value="${data[0].id}" selected>${data[0].name}</option>`);
        $("#append-agency").append(opt);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
    });
    $(document).on("click",".date_picker",function(){
      $(this).datepicker({
        dateFormat: "dd-mm-yy",
        changeMonth: true,
        changeYear: true
      });
    });
  });
  function select_client(obj){
    $("#appended-client").empty();
    $("#append-client").empty();
    $("#appended-client").append(`<option value="${$(obj).data("id")}" selected>${$(obj).text()}</option>`);
    $("#client-search").val($(obj).text());
  }
  function select_agency(obj){
    $("#appended-agency").empty();
    $("#append-agency").empty();
    $("#appended-agency").append(`<option value="${$(obj).data("id")}" selected>${$(obj).text()}</option>`);
    $("#agency-search").val($(obj).text());
  }
  // $(document).on("click","div",function(){
  //   $("#append-agency").empty();
  //   $("#append-client").empty();
  // });
  $(document).on("click","#btn-create-client",function(){
    $("#create-new-client").modal("show");
  });
  $(document).on("submit","#form-create-new-submit",function(e){
    e.preventDefault();
    $('.main-spinner').show();
     $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
      });
      $.ajax({
          url: '{{route("store_pos_client")}}',
          type: 'POST',
          dataType: 'JSON',
          data:$(this).serialize(),
      })
      .done(function(data) {
        $('.main-spinner').hide();
        $("#client-id").append(`
          <option value="${data.id}">
            ${data.name}
          </option>
        `);
        toastr.success("Client create successfully !");
        console.log("success");
      })
      .fail(function() {
        $('.main-spinner').hide();
        toastr.warning("Error with your request, Please try again !");
        console.log("error");
      })
      .always(function() {
          $("#create-new-client").modal("hide");
      });
  });
  function sum_item_price (){
    let item_price = 0;
    $(".cart-list-item-price").each(function(index,value){
      item_price += parseFloat($(value).data("item_price"));
    });
    return item_price;
  }
  $(document).on("change keyup","input[name=discount_amount]",function(){
      let total_item_price = sum_item_price();
      let percentage = parseFloat($(this).val())*100/total_item_price;
      $("input[name=discount_percentage]").val(percentage);
  });
  $(document).on("change keyup","input[name=discount_percentage]",function(){
      let total_item_price = sum_item_price();
      let amount = parseFloat($(this).val())*total_item_price/100;
      $("input[name=discount_amount]").val(amount);
  });
</script>
@endsection
