@extends("layouts.master")
@section("content")
@include('installment.input_type_relationship')
@include('installment.edit-loan-installment')
<style>
.form-control:disabled, .form-control[readonly] {
    background-color: transparent;
    opacity: 1;
}
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" id="content-wrapper-id">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Installment")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.POS Operation")}}</li>
              <li class="breadcrumb-item"><a href="{{route("deposit.index")}}">{{__('application.Deposit')}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Installment")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
    {!! Form::open(array('route' => 'installment.store','method'=>'POST')) !!}
      <div class="row">
        <div class="col-12">
    	<!-- card loan information -->
            <div class="card card-default">
              <!-- /.card-header -->
                <div class="card-header border-transparent">
                    <h2 class="card-title">{{__("application.Information")}} {{__("application.Of")}} {{__("application.Loan")}} </h2>

                    <div class="card-tools">
                      <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                      </button>
                      <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group" style="display: none;">
                                <input type="hidden" name="sale_id" value="{{$loan_data->sale_id}}" required>
                                <strong>{{__("application.Agency")}} {{__("application.Name")}}:</strong>
                                {!! Form::text('agency', $loan_data->agency_name, array('placeholder' => __("application.Agency")." ".__("application.Name"),'class' => 'form-control','readonly')) !!}
                            </div>
                            <div class="form-group">
                                <strong class="required">{{__("application.Category")}}:</strong>
                                {!! Form::text('category', $loan_data->category_name, array('placeholder' => __("application.Category"),'class' => 'form-control','required','readonly')) !!}
                            </div>
                            <div class="form-group">
                                <strong class="required">{{__("application.Project")}}:</strong>
                                {!! Form::text('project', $loan_data->project_name, array('placeholder' => __("application.Project"),'class' => 'form-control','required','readonly')) !!}
                            </div>
                            <div class="form-group">
                                <strong class="required">{{__("application.Item")}}:</strong>
                                {!! Form::text('item', $loan_data->item_name, array('placeholder' => __("application.Item"),'class' => 'form-control','required','readonly')) !!}
                            </div>
                        <!-- /.form-group -->
                        </div>
                      <!-- /.col -->
                        <div class="col-md-6">
                        	<div class="form-group">
                                <strong class="required">{{__("application.Client")}} {{__("application.Name")}}:</strong>
                                {!! Form::text('client', $loan_data->client_name, array('placeholder' =>__("application.Client")." ".__("application.Name"),'class' => 'form-control','required','readonly')) !!}
                            </div>
                            <div class="form-group">
                                <strong>{{__("application.Policy")}} {{__("application.Payment")}}:</strong>
                                {!! Form::select('policy_payment',$policy_payments,optional($loan_data)->policy_payment_id, array('class' => 'form-control select2','required')) !!}
                            </div>
                            <div class="form-group">
                                <strong>{{__("application.Policy")}} {{__("application.Payment")}} {{__("application.Detail")}}:</strong>
                                {!! Form::select('policy_payment_detail', $policy_payments_details,optional($loan_data)->policy_payment_detail_id, array('class' => 'form-control select2','required')) !!}
                            </div>
                            <div class="form-group" style="display: none;">
					            <strong>{{__("application.Client Relationship")}}:</strong>
                                <select name="client_relationship" class="form-control select2" multiple data-placeholder="Please Select" id="client-relationship-selected">
                                	@foreach($client_relationships as $key => $value)
                                		<option value="{{$value->id}}" data-phone="{{$value->phone}}">{{$value->name}}</option>
                                	@endforeach
                                </select>
					              <!-- /.card-header -->
					            <div class="card-body p-0" id="list-client-relationship">
					                <div class="table-responsive">
					                  <table class="table m-0">
					                    <thead>
					                    <tr>
					                      <th>{{__("application.Client Relationship")}} {{__("application.Name")}}</th>
					                      <th>{{__("application.Phone")}}</th>
					                      <th>{{__("application.Type")}} {{__("application.Of")}} {{__("application.Relationship")}}</th>
					                    </tr>
					                    </thead>
					                    <tbody id="tb-list-client-relationship">
					                    </tbody>
					                  </table>
					                </div>
					                <!-- /.table-responsive -->
					            </div>
					              <!-- /.card-body -->
					        </div>
                        </div>
                        <div class="col-md-12">
                            &nbsp;
                        </div>
                      <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
              <!-- /.card-body -->
            </div>
        <!-- /.card -->
        <!-- card payment information step-->
            <div class="card card-default" id="payment-information-step">
              <!-- /.card-header -->
                <div class="card-header border-transparent">
                    <h3 class="card-title">{{__("application.Information")}} {{__("application.Of")}} {{__("application.Payment")}} </h3>

                    <div class="card-tools">
                      <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                      </button>
                      <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <strong class="required">{{__("application.Amount")}} {{__("application.Sale")}}($):</strong>
                                {!! Form::number('sale_amount', $loan_data->sale_amount, array('placeholder' => 'Price','class' => 'form-control','required','id'=>'sale-amount','readonly','step'=>'any')) !!}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <strong>{{__("application.Amount")}} {{__("application.Of")}} {{__("application.Discount")}}($):</strong>
                                {!! Form::number('discount_amount', $loan_data->discount_amount, array('placeholder' => __("application.Amount")." ".__("application.Of")." ".__("application.Discount"),'class' => 'form-control','id'=>'discount-amount',"step"=>"any")) !!}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <strong>{{__("application.Percentage")}} {{__("application.Of")}} {{__("application.Discount")}} (%):</strong>
                                {!! Form::number('discount_percent', $loan_data->discount_amount*100/$loan_data->sale_amount, array('placeholder' => __("application.Percentage")." ".__("application.Percentage")." ".__("application.Discount"),'class' => 'form-control','required','id'=>'discount-percent',"step"=>"any")) !!}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <strong class="required">{{__("application.Sale")}} {{__("application.Price")}}($):</strong>
                                {!! Form::number('remain_amount', $loan_data->sale_amount, array('placeholder' => __("application.Amount")." ".__("application.Remain"),'class' => 'form-control','required','id'=>'remain-amount-main','readonly','step'=>'any')) !!}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <strong class="required">{{__("application.Amount")}} {{__("application.Deposit")}}($):</strong>
                                {!! Form::number('deposit_amount', $loan_data->sale_receive_amount, array('placeholder' => __("application.Amount")." ".__("application.Deposit"),'class' => 'form-control','required','id'=>'deposit-amount','readonly','step'=>'any')) !!}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <strong class="required">{{__("application.Date")}} {{__("application.Of")}} {{__("application.Disburment")}}:</strong>
                                {!! Form::text('disburment_date', date("d-m-Y"), array('placeholder' => __("application.Date"),'class' => 'form-control date_picker','required','id'=>'disburment-date')) !!}
                            </div>
                        </div>
                    </div>
                    <!-- /.row -->
                </div>
              <!-- /.card-body -->
                {{-- <div class="card-footer" style="display: none;">
                    <div style="text-align: right;">
                        <button type="button" class="btn btn-sm btn-default" title="Installment Step with Loan" style="background-color: #6EB81C;color:white;" id="installment-step-loan">Step & Loan</button>
                    </div>
                </div> --}}
            </div>
        <!-- /.card -->

        </div>
        <!-- /.col -->
      </div>
      <!-- TABLE: loan Interest -->

      <!-- TABLE: loan payment -->
      <!--Installment Step-->
      <div id="loan-payment-info1">
        <div class="card" id="loan-payment-step">
            <div class="card-header border-transparent">
                <h2 class="card-title">Loan Step Payment</h2>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

          <!-- /.card-header -->
                <div class="card-body p-0" id="generate-step-loan">
                    <div class="m-1">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">Term:</strong>
                                    <select name="step_term" class="form-control select2">
                                        <option value="1">Weekly</option>
                                        <option value="2" selected>Monthly</option>
                                        <option value="3">Yearly</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">Count:</strong>
                                    <input type="text" name="step_count" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="card-footer" style="background-color: transparent !important;">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-success" id="step-generate">Generate</button>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table m-0">
                            <thead>
                                <tr><input type="hidden" name="installment_type_step" value="1">
                                    <th>No.</th>
                                    <th>Payment Date</th>
                                    <th>Payment Amount($)</th>
                                    <th>Payment Percentage(%)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="tb-step-generate">
                                <tr>
                                    <td>1</td>
                                    <td>
                                        <input type="text" class="form-control payment-date-tr date_picker" name="date_payment_step[]"
                                            placeholder="Date Payment" id="dates-1" value="{{ date('d-m-Y') }}">
                                    </td>
                                    <td>
                                        <input type="number" class="form-control nso-amount-input-step" name="payment_amount_step[]"
                                        placeholder="Payment Amount" onkeyup="input_amount(this)" onchange="input_amount(this)" step="any">
                                    </td>
                                    <td>
                                        <input type="number" class="form-control" name="payment_pecentage_step[]" placeholder="Payment Percentage" onkeyup="input_percentage(this)" onchange="input_percentage(this)" step="any">
                                    </td>
                                    <td>
                                        <button type="button" disabled class="btn btn-md btn-danger" onclick="Remove_row(this)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="2" style="text-align: right;"></td>
                                    <td><label>Remain Amount($)</label>
                                        <input type="number" class="form-control" name="remain_amount_step"
                                        placeholder="Remain Amount" required readonly id="remain-amount-step" step="any">
                                    </td>
                                    <td><label>Remain Percentage(%)</label>
                                        <input type="number" class="form-control" name="remain_percentage_step"
                                        placeholder="Remain Percentage" required readonly id="remain-percentage-step" step="any">
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.table-responsive -->
                </div>
          <!-- /.card-body -->
            <div class="card-footer">
                <div style="text-align: right;">
                    <button type="button" class="btn btn-sm btn-info" id="add-step"><i class="fas fa-plus"></i> Add Step</button>
                </div>
            </div>
          <!-- /.card-footer -->
        </div>
      </div>
      <!--End Installment Step-->

      <!--Installment Loan First-->
      <div id="loan-payment-info">
        <div class="card" id="loan-payment-generate">
            <div class="card-header border-transparent">
                <h2 class="card-title">First Loan Payment Info</h2>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

          <!-- /.card-header -->
            <div class="card-body p-1">
                <div class="m-1">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" name="installment_type_first_loan" value="0" id="installment-type-first-loan">
                                <strong class="required">Type:</strong>
                                <select name="loan_type" class="form-control select2" id="term-type">
                                    <option value="1">ថយ</option>
                                    <option value="2" selected>ថេរ</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Term:</strong>
                                <input type="text" name="loan_term" class="form-control" value="month" readonly>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Remain Amount:</strong>
                                <input type="number" name="loan_amount_after_step" class="form-control" placeholder="Amount" id="loan_amount_after_step" step="any" readonly>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Next Payment Date:</strong>
                                <input type="text" name="next_payment_date" class="form-control next_payment_date date_picker" placeholder="Next Payment Date"
                                 id="date-for-next-payment" value="{{ date('d-m-Y') }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Loan Amount:</strong>
                                <input type="number" name="loan_amount_first" class="form-control" placeholder="Amount" id="loan-amount-first" step="any">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Loan Percentage:</strong>
                                <input type="number" name="Loan_percentage_first" class="form-control" placeholder="Amount" id="Loan-percentage-first" step="any">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Duration Year:</strong>
                                        <input type="number" name="duration_year" value="0" class="form-control" placeholder="Duration Year" id="duration-year" step="any">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Duration Month:</strong>
                                        <input type="number" name="duration_month" value="0" class="form-control" placeholder="Duration Month" id="duration-month" step="any">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <strong class="required">Total Numbe of month:</strong>
                                        <input type="number" name="number_of_month" value="0" readonly class="form-control" placeholder="Numbe of month" id="number-of-month" step="any">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Interest Year(%):</strong>
                                        <input type="number" name="interest_year" value="0" class="form-control" placeholder="Insterest Year" id="interest-year" step="any">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Interest Month(%):</strong>
                                        <input type="number" name="interest_month" value="0" class="form-control" placeholder="Insterest Month" id="interest-month" step="any">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <strong class="required">Total Interest(Month)%:</strong>
                                        <input type="number" name="interest" readonly value="0" class="form-control" placeholder="Insterest" id="insterest-loan" step="any">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group" id="div-amount-per-month">

                            </div>
                        </div>
                    </div>
                  <!-- /.col -->
                </div>
            </div>
          <!-- /.card-body -->
            <div class="card-footer">
                <div style="text-align: right;">
                    <button type="button" class="btn btn-sm btn-success" id="generate-loan-info">Generate</button>
                </div>
            </div>
          <!-- /.card-footer -->
        </div>
      </div>
      <!--End Installment Loan First-->

      <!--Installment Loan Second-->
      <div id="loan-payment-second-info">
        <div class="card">
            <div class="card-header border-transparent">
                <h2 class="card-title">Second Loan Payment Info</h2>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

          <!-- /.card-header -->
            <div class="card-body p-1">
                <div class="m-1">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" name="installment_type_second_loan" value="0" id="installment-type-second-loan">
                                 <strong class="required">Type:</strong>
                                 <select name="loan_type_second" class="form-control select2" id="term-type-second">
                                     <option value="1">ថយ</option>
                                     <option value="2" selected>ថេរ</option>
                                 </select>
                             </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Term:</strong>
                                <input type="text" name="loan_term_second" class="form-control" value="month" readonly>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Remain Amount:</strong>
                                <input type="number" name="loan_amount_after_loan_first" class="form-control" placeholder="Amount" id="loan_amount_after_loan_first" step="any" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Next Payment Date:</strong>
                                <input type="text" name="next_payment_date_second" class="form-control next_payment_date date_picker" placeholder="Next Payment Date" id="date-for-next-payment-second" value="{{ date("d-m-Y") }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Loan Amount:</strong>
                                <input type="number" name="loan_amount_second" class="form-control" placeholder="Amount" id="loan-amount-second" step="any">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Loan Percentage:</strong>
                                <input type="number" name="loan_percentage_second" class="form-control" placeholder="Amount" id="loan-percentage-second" step="any">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">Number of month:</strong>
                                <input type="number" name="number_of_month_second" class="form-control" placeholder="Numbe of month" id="number-of-month-second" step="any">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Interest Option:</strong>
                                            <select name="interest_second_option" class="select2" id="insterest-option-loan-second">
                                                <option value="1" selected>ការប្រាក់ធម្មតា</option>
                                                <option value="2">ផ្លាស់ប្តូរការប្រាក់</option>
                                            </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Interest:</strong>
                                        <input type="number" name="interest_second" class="form-control" placeholder="Insterest" id="insterest-loan-second" step="any">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group" id="div-amount-per-month-second">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table m-0">
                                <thead>
                                    <tr>
                                        <th>{{ __('application.From') }} {{ __('application.Month') }}</th>
                                        <th>{{ __('application.To') }} {{ __('application.Month') }}</th>
                                        <th>{{ __('application.Interest') }}</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="list-change-record-change-ineterest">
                                    <tr>
                                        <td>
                                            <input type="number" class="form-control change_rate_from" name="from_month[]"
                                            placeholder="{{  __('application.From') }} {{ __('application.Month') }}" step="any">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control change_rate_to" name="to_month[]"
                                            placeholder="{{  __('application.To') }} {{ __('application.Month') }}" step="any">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control rate_condition" name="change_interest[]"
                                            placeholder="{{ __('application.Interest') }}" step="any">
                                        </td>
                                        <td>
                                            <button type="button" disabled class="btn btn-md btn-danger" onclick="Remove_row(this)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                  <!-- /.col -->
                </div>
            </div>
          <!-- /.card-body -->
            <div class="card-footer">
                <div style="text-align: right;">
                    <button type="button" class="btn btn-sm btn-info" id="add_record_change_insterest" onclick="add_record_change_insterest_fun(this)">Add Record</button>
                    <button type="button" class="btn btn-sm btn-success" id="generate-loan-info-second">Generate</button>
                </div>
            </div>
          <!-- /.card-footer -->
        </div>
      </div>
      <!--End Installment Loan Second-->

      <!--Installment Loan Second Generate-->
      <div id="loan-payment-scond-generate"></div>
      <!--End Installment Loan Second Generate-->

      <!--Installment Loan with Bank-->
      <div id="loan-with-bank">
        <div class="card" id="loan-payment-step">
            <div id="loan-payment-info-interest">
                <div class="card" id="loan-payment-interest">
                    <div class="card-header border-transparent">
                        <h2 class="card-title">Loan Interest Only</h2>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0" id="generate-step-loan-interest">
                        <div class="m-1">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Loan Amount</strong>
                                        <input type="text" name="loan_amount" class="form-control" id="loan_amount">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong>Loan Fee</strong>
                                        <input type="text" name="loan_fee" value="0" class="form-control loan_fee">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Term:</strong>
                                        <select name="loan_term_interest" class="form-control select2 loan_term_interest">
                                            <option value="0">Daily</option>
                                            <option value="1">Weekly</option>
                                            <option value="2" selected>Monthly</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Loan Term</strong>
                                        <input type="text" name="loan_term_interest" class="form-control loan_term_interest">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Rate Type</strong>
                                        <select name="loan_rate_interest" class="form-control select2 loan_rate_interest">
                                            <option value="0">Rate(%)</option>
                                            <option value="1">Rate($)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">Rate</strong>
                                        <input type="text" name="loan_rate" class="form-control loan_rate">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <strong class="required">First Pay Date</strong>
                                        <input type="text" name="loan_term_date" id="loan_term_date" value="{{date('d-m-Y')}}" class="form-control date_picker">
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer" style="background-color: transparent !important;">
                                <div style="text-align: right;">
                                    <button type="button" class="btn btn-sm btn-success" id="step-generate-interest">Generate</button>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Payment Date</th>
                                    <th>Payment Amount</th>
                                    <th>Principle</th>
                                    <th>Interest</th>
                                    <th>Total</th>
                                    <th>Amount To Pay</th>
                                    <th>Balance</th>
                                </tr>
                                </thead>
                                <tbody id="tb-interest-generate">
                                    <tr>


                                    </tr>
                                </tbody>
                                <tfoot id="tbf-interest-generate">
                                <tr id="ff">

                                </tr>
{{--                                <tr>--}}
{{--                                    <td colspan="2" style="text-align: right;"></td>--}}
{{--                                    <td><label>Remain Amount($)</label>--}}
{{--                                        <input type="number" class="form-control" name="remain_amount_interest"--}}
{{--                                               placeholder="Remain Amount" required readonly id="remain-amount-interest" step="any">--}}
{{--                                    </td>--}}
{{--                                </tr>--}}
                                </tfoot>
                            </table>
                        </div>
                    </div>
            </div>
            <!-- /.card-body -->

          <!-- /.card-footer -->
        </div>


            <div class="card-header border-transparent">
                <h2 class="card-title">Bank Loan Payment</h2>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <!-- /.card-header -->
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table m-0">
                        <thead>
                        <tr><input type="hidden" name="installment_type_bank" value="4">
                            <th>No.</th>
                            <th>Payment Date</th>
                            <th>Payment Amount($)</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>1</td>
                            <td>
                                <input type="text" class="form-control payment-date-tr-bank date_picker" name="date_payment_bank"
                                       placeholder="Date Payment" id="date-1">
                            </td>
                            <td>
                                <input type="number" class="form-control nso-amount-input-step" name="payment_amount_bank"
                                       placeholder="Payment Amount"  onchange="total_amount_input_step(Number($(this).val()),3)" step="any">
                            </td>
                            <td>
                                <button type="button" disabled class="btn btn-md btn-danger" onclick="Remove_row(this)">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="2" style="text-align: right;"></td>
                            <td><label>Remain Amount($)</label>
                                <input type="number" class="form-control" name="remain_amount_bank"
                                       placeholder="Remain Amount" required readonly id="remain-amount-bank" step="any">
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- /.table-responsive -->
            </div>
            <div class="card-footer">
                <div style="text-align: right;">
                    <input type="hidden" value="0" id="remain-amount-check">
                    <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> Back</button>
                    <button type="submit" class="btn btn-sm btn-success fa fa-save" id="btn-step-submit"> Submit</button>
                </div>
            </div>

        </div>
      </div>
      <!--End Installment Loan with Bank-->

    <!-- /.card -->
      <!-- /.row -->
    {!! Form::close() !!}
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@include('installment.footer-script')
