@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.travel-request.confirm-delete')

    <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title">{{ __('administrator.are_you_sure')}}</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <br/>
                <form role="form" method="POST" id="form_update">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-md-12">
                            <div class="col-md-12">
                                <input type="hidden" name="id" id="id">
                            </div>
                            <div class="form-group col-sm-12 col-xs-12">
                                <label class="required">{{ __('administrator.status')}}</label>
                                <select name="status" class="form-control input-lg" required>
                                    <option value="">{{ __('administrator.please_select')}}</option>
                                    <option value="1">{{ __('administrator.approve')}}
                                    </option>
                                    <option value="2">{{ __('administrator.reject')}}
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                    class="fa fa-close"></i> {{ __('administrator.close')}}
                        </button>
                        <button type="submit" class="btn btn-success" data-toggle="modal"><i
                                    class="fa fa-save"></i> {{ __('administrator.save')}}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade bs-modal-lg" id="viewModal" tabindex="-2" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title">{{ __('administrator.info_detail') }} </h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <br/>
                <div class="row" style="line-height: 5px">
                    <div class="col-md-12">
                        <table class="table">
                            <tr>
                                <td>{{ __('administrator.employee') }}</td>
                                <td><span class="emp"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.travel_by') }}</td>
                                <td><span class="travel_by"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.purpose') }}</td>
                                <td><span class="purpose"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.from') }}</td>
                                <td><span class="from"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.to') }}</td>
                                <td><span class="to"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.from_date') }}</td>
                                <td><span class="from_date"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.to_date') }}</td>
                                <td><span class="to_date"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.request_amount') }}</td>
                                <td><span class="request_amount"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.document') }}</td>
                                <td><span class="document"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.note') }}</td>
                                <td><span class="note"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.status') }}</td>
                                <td><span class="status"></span></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-danger"><i class="fa fa-close"></i>Close
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.travel_request")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.travel_request")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Travel Request Create'))
                                    <a class="btn btn-sm btn-success" href="{{route('hr-travel-request.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.employee') }}</th>
                                        <th>{{__('administrator.travel_by')}}</th>
                                        <th>{{__('administrator.purpose')}}</th>
                                        <th>{{__('administrator.from_location')}}</th>
                                        <th>{{__('administrator.to_location')}}</th>
                                        <th>{{__('administrator.from_date')}}</th>
                                        <th>{{__('administrator.to_date')}}</th>
                                        <th>{{__('administrator.request_amount')}}</th>
                                        <th>{{__('administrator.status')}}</th>
                                        <th style="width: 250px;">{{__('administrator.action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn-delete-travel', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $(document).on('click', '.viewPopLink', function () {
                var id = $(this).data('id');
                $('#id').val(id);
                var url = "{{route('hr.travel-change-status')}}";
                $('#form_update').attr('action', url);
                $('#myModal').modal('show');
            });

            $(document).on('click', '.viewtravel', function () {
                var id = $(this).data('id');
                $('#viewModal').modal('show');
                $.ajax({
                    url: "{{route('hr.travel-view')}}",
                    type: 'GET',
                    data: {
                        "id": id,
                    },
                    success: function (data) {
                        $('.emp').text(data.datas.employee);
                        $('.purpose').text(data.datas.purpose);
                        $('.travel_by').text(data.datas.travel_by);
                        $('.from').text(data.datas.from);
                        $('.to').text(data.datas.to);
                        $('.from_date').text(data.datas.from_date);
                        $('.to_date').text(data.datas.to_date);
                        $('.request_amount').text(data.datas.amount);
                        file1 = data.datas.file1;
                        file2 = data.datas.file2;
                        file1 = file1.substring(8, file1.length);
                        file2 = file2.substring(8, file2.length);
                        d1 = data.datas.file1 ? '<a target="_blank" href="/assets/attachment_file/' + data.datas.file1 + '"><span class="fa fa-download"></span> ' + file1 + '</a>' : '';
                        d2 = data.datas.file2 ? '<a target="_blank" href="/assets/attachment_file/' + data.datas.file2 + '"><span class="fa fa-download"></span> ' + file2 + '</a>' : '';
                        file = d1 + '<br><br>' + d2;
                        $('.document').html(file);
                        $('.note').text(data.datas.note);
                        $('.status').html(data.datas.statuss);
                    }
                });
            });

            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{ route('datatable.hr-get-travel-request') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'emp_id'},
                        {data: 'travel_by'},
                        {data: 'purpose'},
                        {data: 'from'},
                        {data: 'to'},
                        {data: 'from_date'},
                        {data: 'to_date'},
                        {data: 'amount'},
                        {data: 'status'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
