@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <style>
        input[type="file"] {
            display: block;
        }
    </style>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.travel_request")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.travel_request")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.Create New")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::open(array('route' => 'hr-travel-request.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.employee')}}</label>
                                    {!! Form::select('emp_id', $emp,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.travel_by')}}</label>
                                    {!! Form::text('travel_by', null, array('placeholder' => __('administrator.travel_by'),'class' => 'form-control','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.purpose')}}</label>
                                    {!! Form::text('purpose', null, array('placeholder' => __('administrator.purpose'),'class' => 'form-control','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.from')}} ({{__('administrator.location')}})</label>
                                    {!! Form::text('from', null, array('placeholder' => __('administrator.from'),'class' => 'form-control','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.to')}} ({{__('administrator.location')}})</label>
                                    {!! Form::text('to', null, array('placeholder' => __('administrator.to'),'class' => 'form-control','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.from_date')}}</label>
                                    {!! Form::text('from_date', null, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.to_date')}}</label>
                                    {!! Form::text('to_date', null, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.amount')}}</label>
                                    {!! Form::number('amount', null, array('placeholder' => __('administrator.amount'),'class' => 'form-control','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.currency')}}</label>
                                    {!! Form::select('currency', [''=>__('administrator.please_select'),'riel'=>__('administrator.riel').' ( ៛ )​​​','usd'=>__('administrator.usd').' ( $ )'],null, array('class' => 'form-control select2','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="" for="name">{{__('administrator.note')}}</label>
                                    {!! Form::textarea('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control no-resize','rows'=>'3')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="" for="name">{{__('administrator.document_ref')}}</label>
                                    {!! Form::file('file1', null, array('placeholder' => __('administrator.document_ref'),'class' => 'form-control','')) !!}
                                    {!! Form::file('file12', null, array('placeholder' => __('administrator.document_ref'),'class' => 'form-control','')) !!}
                                    
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection


    

