@extends("layouts.master")
@section('content')
    <?php Fun::lang() ?>
    @include('hr.take-leave-authorize.modal-status')
    @include('hr.take-leave-authorize.modal-deduct')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.take_leave_authorize')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.take_leave_authorize')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {{-- <div class="card-header">
                            <div class="pull-left">
                                <div class="alert-message alert-success" style="display: none">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    <i class="fa fa-check"></i>
                                    <h3>Success</h3>
                                    <p class="message"></p>
                                </div>
                                <a class="btn btn-sm btn-success" href="#"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                            </div>
                        </div> --}}
                        <div class="card-body">
                            <table id="datatable_leave" class="table table-striped table-bordered table-hover nowrap">
                                <thead>
                                    <tr>
                                        <th >#</th>
                                        <th >{{__('administrator.employee')}}</th>
                                        <th >{{__('administrator.from_date')}}</th>
                                        <th >{{__('administrator.to_date')}}</th>
                                        <th >{{__('administrator.request_date')}}</th>
                                        <th >{{__('administrator.request_to')}}</th>
                                        <th >{{__('administrator.leave_type')}}</th>
                                        <th >{{__('administrator.total_leave')}}</th>
                                        <th >{{__('administrator.reviews')}}</th>
                                        <th >{{__('administrator.approve')}}</th>
                                        <th style="width: 200px;">{{__('administrator.action')}}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection


@section('js')

    <script type="text/javascript">
        $(function () {
            $(document).on('click', '.btn_status_authorize', function(){
                var id = $(this).data('id');
                $('#id').val(id);
                $('#form-status').modal('show');
            });

            $(document).on('click', '.btn_deduct', function(){
                var id = $(this).data('id');
                $('#ids').val(id);
                $('#form-deduct').modal('show');
            });

            $('#datatable_leave').DataTable({
                ordering: false,
                processing: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 1000], [20, 30, 50, 100, 1000]], 
                ajax: '{{ route("take-leave-authorize.index") }}',
                columns: [
                    { data: 'DT_RowIndex', searchable: false},
                    { data: 'emp_id'},
                    { data: 'from_date'},
                    { data: 'to_date'},
                    { data: 'request_date'},
                    { data: 'request_to'},
                    { data: 'leave_type'},
                    { data: 'num_take_leave'},
                    { data: 'review'},
                    { data: 'approve'},
                    { data: 'action',searchable: false},
                ],
            });

        });

    </script>
@stop
