@extends("layouts.master")

@section('content')
    @include('hr.resign.confirm-delete')
    <?php Fun::lang()?>
    
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.resign")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.resign")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.code')}}</th>
                                        <th>{{__('administrator.english_name')}}</th>
                                        <th>{{__('administrator.khmer_name')}}</th>
                                        <th>{{__('administrator.branch')}}</th>
                                        <th>{{__('administrator.department')}}</th>
                                        <th>{{__('administrator.position')}}</th>
                                        <th>{{__('administrator.resign_date')}}</th>
                                        <th>{{__('administrator.type')}}</th>
                                        <th>{{__('administrator.reason')}}</th>
                                        <th style="width: 200px;">{{__('administrator.action')}}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click','.btn-delete-resign', function(){
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 1000], [20, 30, 50, 100, 1000]],
                ajax: "{{route('datatable.hr-get-emp-resign')}}",
                columns:
                [
                    {data: 'DT_RowIndex', searchable: false},
                    {data: 'code'},
                    {data: 'name_kh'},
                    {data: 'name'},
                    {data: 'branch_id'},
                    {data: 'department_id'},
                    {data: 'position_id'},
                    {data: 'resign_date'},
                    {data: 'type'},
                    {data: 'reason'},
                    {data: 'action',searchable: false},
                ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
