@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    @php

    @endphp
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.salary_authorize")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.salary_authorize")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            {!! Form::open(array('route' => 'get-report-employee','method'=>'get')) !!}
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <strong for="">{{__('administrator.employee')}}</strong>
                                            {!! Form::select('emp_id',$user ,null, ['class' => 'form-control select2','autocomplete' => 'off']) !!}
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <strong for="">{{__('administrator.branch')}}</strong>
                                            {!! Form::select('branch_id', $branch, null, array('class' => 'form-control select2','autocomplete' => 'off')) !!}
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <strong for="">{{__('administrator.department')}}</strong>
                                            {!! Form::select('department_id', $department, null, array('class' => 'form-control select2','autocomplete' => 'off')) !!}
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <strong for="">{{__('administrator.position')}}</strong>
                                            {!! Form::select('position_id', $position, null, array('class' => 'form-control select2','autocomplete' => 'off')) !!}
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <strong for="">{{__('administrator.from_date')}}</strong>
                                            {!! Form::text('from_date', null, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker','id' => 'from_date','autocomplete' => 'off','')) !!}
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <strong for="">{{__('administrator.to_date')}}</strong>
                                            {!! Form::text('to_date', null, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker', 'id' => 'to_date','autocomplete' => 'off','')) !!}
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div style="text-align: right">
                                            {{-- <button class="btn btn-sm btn-primary pull-right" type="button" onclick="search()"><i class="fa fa-search "></i> {{__('administrator.search')}}</button>
                                            <button class="btn btn-sm btn-success pull-right" type="button" onclick="tableToExcel('print_tables','employee by branch')"><i class="fa fa-file-excel"></i> {{__('administrator.excel')}}</button>
                                            <button class="btn btn-sm btn-info pull-right print_button" type="button" data-text="{{__('administrator.salary_authorize')}}"><i class="fa fa-print"></i> {{__('administrator.print')}}</button> --}}
                                        </div>
                                    </div>
                                </div>
                            {!! Form::close() !!}

                            <table id="print_table" width="100%" class="table table-striped table-hover ">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.employee')}}</th>
                                        <th>{{__('administrator.month')}}</th>
                                        <th>{{__('administrator.year')}}</th>
                                        <th>{{__('administrator.basic_salary')}}</th>
                                        <th>{{__('administrator.advance_salary')}}</th>
                                        <th>{{__('administrator.take_leave')}}</th>
                                        <th>{{__('administrator.benefit')}}</th>
                                        <th>{{__('administrator.total_ot')}}</th>
                                        <th>{{__('administrator.net_pay_kh')}}</th>
                                        <th>{{__('administrator.net_pay_th')}}</th>
                                        <th>{{__('administrator.net_pay')}}</th>
                                    </tr>
                                </thead>
                                <tbody class="tbody">
            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            search();
        });
        function search(){
            var emp_id          = $('select[name="emp_id"]').find(':selected').val();
            var branch_id       = $('select[name="branch_id"]').find(':selected').val();
            var department_id   = $('select[name="department_id"]').find(':selected').val();
            var position_id     = $('select[name="position_id"]').find(':selected').val();
            var from_date       = $('#from_date').val();
            var to_date         = $('#to_date').val();

            $('#print_table').DataTable().destroy();
            $('#print_table').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                "buttons": [
                    {
                        extend: '',
                        text: 'Search',
                        className: "btn btn-sm btn-primary",
                        titleAttr: 'Search',
                        attr:{
                            id: 'id-search',
                            onclick: 'search()'
                        }
                    },
                    {
                        extend: 'copy',
                        text: window.copyButtonTrans,
                        className: "btn btn-sm btn-primary",
                        titleAttr: 'Copy',
                    },
                    {
                        extend: 'csv',
                        text: window.csvButtonTrans,
                        className: "btn btn-sm btn-success",
                        titleAttr: 'CSV',
                    },
                    {
                        extend: 'excel',
                        text: window.excelButtonTrans,
                        className: "btn btn-sm btn-success",
                        titleAttr: 'Excel',
                    },
                    {
                        extend: 'pdf',
                        text: window.pdfButtonTrans,
                        className: "btn btn-sm btn-danger",
                        titleAttr: 'PDF',
                    },
                    {
                        
                        text: 'Print',
                        className: "btn btn-sm btn-info",
                        titleAttr: 'Print',
                        attr:{
                            id: 'id-print',
                            onclick: 'print()'
                        }
                    }
                ],
                dom: 'Blfrtip',
                ajax: {
                    url:"{{ route('get-report-authorize') }}",
                    type:'POST',
                    data:{
                        _token:"{{csrf_token()}}",
                        emp_id:emp_id,
                        branch_id: branch_id,
                        department_id: department_id,
                        position_id: position_id,
                        from_date: from_date,
                        to_date: to_date
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'employee', 'searchable': false},
                        {data: 'f_month', 'searchable': false},
                        {data: 'f_year', 'searchable': false},
                        {data: 'basic_salary', 'searchable': false},
                        {data: 'advance_salary', 'searchable': false},
                        {data: 'take_leave', 'searchable': false},
                        {data: 'benefit', 'searchable': false},
                        {data: 'total_ot', 'searchable': false},
                        {data: 'net_pay_kh', 'searchable': false},
                        {data: 'net_pay_th', 'searchable': false},
                        {data: 'net_pay', 'searchable': false},

                    ],
            });
            $.fn.dataTable.ext.errMode = 'throw';
        }
        function print(){
            var title=`Report Authorize Salary`;
            var user_name = "{{Auth::user()->name}}";
            var date = "{{\Globals::date_khmers(date('d-m-Y'))}}";
            var table_data = $("#print_table").html();
            print_report(title,table_data,user_name,date);// Refference at master page
        }
    </script>
@stop




