@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <style>
        table, tr, td {
            padding: 5px;
        }
    </style>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.recommendation')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.recommendation')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.Create New")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::open(array('route' => 'hr-recommendation.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-6 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.employee')}}</label>
                                    {!! Form::select('emp_id', $emp ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','autocomplete'=>'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-6 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.request_to')}}</label>
                                    {!! Form::select('request_to', $emp ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','autocomplete'=>'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <table class="table-borderless" style="width: 100%">
                                        <thead>
                                            <tr style="text-align: center;background-color: lightcyan">
                                                <td colspan="4" style="border-right: 5px solid white;">Salary Increment</td>
                                                <td colspan="4">Performance Bonus</td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr style="text-align: center">
                                                <td>{!! Form::radio('in_comment','1', true) !!}</td>
                                                <td>Comment</td>
                                                <td>{!! Form::radio('in_comment','0') !!}</td>
                                                <td>Not Comment</td>
                                                <td>{!! Form::radio('bonus_comment','1', true) !!}</td>
                                                <td>Comment</td>
                                                <td>{!! Form::radio('bonus_comment','0') !!}</td>
                                                <td>Not Comment</td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">{!! Form::text('in_date', null,array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker')) !!}</td>
                                                <td colspan="4">{!! Form::text('bonus_date', null,array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker')) !!}</td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">{!! Form::textarea('in_description', null,array('placeholder' => __('administrator.description'),'class' => 'form-control')) !!}</td>
                                                <td colspan="4">{!! Form::textarea('bonus_description', null,array('placeholder' => __('administrator.description'),'class' => 'form-control')) !!}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table class="table-borderless" style="width: 100%">
                                        <thead>
                                            <tr style="text-align: center;background-color: lightcyan">
                                                <td colspan="4" style="border-right: 5px solid white;">Promotion</td>
                                                <td colspan="4">New Opportunity</td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr style="text-align: center">
                                                <td>{!! Form::radio('pro_comment','1', true) !!}</td>
                                                <td>Comment</td>
                                                <td>{!! Form::radio('pro_comment','0') !!}</td>
                                                <td>Not Comment</td>
                                                <td>{!! Form::radio('opp_comment','1', true) !!}</td>
                                                <td>Comment</td>
                                                <td>{!! Form::radio('opp_comment','0') !!}</td>
                                                <td>Not Comment</td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">{!! Form::textarea('pro_description', null,array('placeholder' => __('administrator.description'),'class' => 'form-control')) !!}</td>
                                                <td colspan="4">{!! Form::textarea('opp_description', null,array('placeholder' => __('administrator.description'),'class' => 'form-control')) !!}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection


    

