@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="title-add">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a class="ng-binding" href="#"><i class="fa fa-dashboard"></i> Dashboard</a> </li>
                <li> <a href="#">Manage HR</a> </li>
                <li> <a class="ng-binding" href="#">{{__('administrator.leave')}}</a> </li>
            </ul>
        </div>
    </div>
    @php
        $day_amt = '';
        $text = '';
        foreach ($detail as $key=>$row){
            if ($row->type == 'day_off') {
                    $text = '<input name="daytype[]" type="hidden" value="day_off"><input name="showtype[]" type="text" class="form-control input-sm" readonly value="'.__('administrator.day_off').'">';
                }else{
                    $text = '<select name="daytype[]" class="form-control input-sm select2">
                            <option value="full_day" '.($row->type=='full_day'?'selected':'').'> '.__('administrator.full_day').' </option>
                            <option value="half_day" '.($row->type=='half_day'?'selected':'').'> '.__('administrator.half_day').' </option>
                            <option value="day_off" '.($row->type=='day_off'?'selected':'').'> '.__('administrator.day_off').' </option>
                            </select>';
                }
                //'  (date < 10 ? ('0'  date) : date)  '-'  (month < 10 ? ('0'  month) : month)  '-'  lday[i].getFullYear()  '
                $day_amt .= ($key > 0 ? '<div class="col-sm-12 col-xs-12 blank5"></div>' : '').
                    '<div class="col-sm-12 col-xs-12"><div class="col-sm-2">
                    <input name="leavedate[]" type="text" class="form-control input-sm" readonly value="'.date('d-m-Y',strtotime($row->date)).'">
                    </div>
                    <div class="col-sm-2">
                    <input name="dayname[]" type="text" class="form-control input-sm" readonly value="'.__('administrator.'.strtolower(date('D',strtotime($row->date)))).' ">
                    </div>
                    <div class="col-sm-2">'.$text.'</div></div>';
    }
    @endphp
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.leave')}}</h3>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        {!! Form::model($leave, ['method' => 'PATCH','route' => ['hr-leave-request.update', $leave->id]]) !!}
        <div class="row">
            <div class="col-sm-12">
                <div class="master-form">
                    <div class="title-note">
                        <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.job')}}
                            <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.employee')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::select('emp_id', $emp,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.leave_type')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::select('leave_type', $ltype,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.from_date')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::text('from_date', date('d-m-Y',strtotime($leave->from_date)), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker from_date','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.to_date')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::text('to_date', date('d-m-Y',strtotime($leave->to_date)), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker to_date','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.leave_date')}}</label>
                        </div>
                        <div class=" col-sm-8 col-xs-12 day_amt">
                            {!! $day_amt !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.reason')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::textarea('reason', null, array('placeholder' => __('administrator.reason'),'class' => 'form-control no-resize','required','rows'=>'3')) !!}
                        </div>
                    </div>
                    {{--<div class="form-group col-sm-12 col-xs-12">--}}
                    {{--<div class="col-sm-3 col-xs-12 ">--}}
                    {{--<label class="" for="name">{{__('administrator.document_ref')}}</label>--}}
                    {{--</div>--}}
                    {{--<div class="col-sm-8">--}}
                    {{--{!! Form::file('file', null, array('placeholder' => __('administrator.document_ref'),'class' => 'form-control','')) !!}--}}
                    {{--</div>--}}
                    {{--</div>--}}

                    <div class="col-sm-11 col-xs-12">
                        <div class="form-group footer-save">
                            <button type="submit" class=" button_primary pull-right"><span
                                        class="fa fa-save"></span> {{__('administrator.next')}}</button>
                            <button type="button" onClick="history.go(-1)"
                                    class=" button_warning pull-right">
                                <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
@endsection
@section('js')
    <script>

        $(document).ready(function () {

            var dname = [];
            var dwork = [];
            var dcode = [];

            @foreach($wd as $key=>$row)
            name['{{$key}}'] = '{{$row->name}}';
            dcode['{{$key}}'] = '{{$row->code}}';
            dwork[0] = '{{$row->work}}';
                    @endforeach

            var weekday = [
                    "{{__('administrator.day7')}}",
                    "{{__('administrator.day1')}}",
                    "{{__('administrator.day2')}}",
                    "{{__('administrator.day3')}}",
                    "{{__('administrator.day4')}}",
                    "{{__('administrator.day5')}}",
                    "{{__('administrator.day6')}}"
                ];

            function find_day() {
                setTimeout(function () {
                    var arr1 = [];
                    var arr2 = [];
                    var day_amt = '';
                    fdate = $(".from_date").val();
                    tdate = $(".to_date").val();
                    arr1 = fdate.split('-');
                    arr2 = tdate.split('-');
                    f_date = arr1[1] + '/' + arr1[0] + '/' + arr1[2];
                    t_date = arr2[1] + '/' + arr2[0] + '/' + arr2[2];
                    var date1 = new Date(f_date);
                    var date2 = new Date(t_date);
                    lday = [];
                    i = 0;

                    // oush date to array
                    var startTime = date1.getTime(), endTime = date2.getTime();
                    for (loopTime = startTime; loopTime <= endTime; loopTime += 86400000) {
                        lday[i] = new Date(loopTime);
                        i++;
                    }

                    // find total day
                    var Difference_In_Time = date2.getTime() - date1.getTime();
                    var Difference_In_Days = Difference_In_Time / (1000 * 3600 * 24);

                    for (i = 0; i < (Difference_In_Days + 1); i++) {
                        dayoff = '';
                        month = lday[i].getMonth() + 1;
                        date = lday[i].getDate();
                        day = lday[i].getDay();
                        if (dwork[day]) {
                            $text = '<input name="daytype[]" type="hidden" value="day_off"><input name="showtype[]" type="text" class="form-control input-sm" readonly value="{{__('administrator.day_off')}}">';
                        } else {
                            $text = '<select name="daytype[]" class="form-control input-sm select2">' +
                                '<option value="full_day"> {{__('administrator.full_day')}} </option>' +
                                '<option value="half_day"> {{__('administrator.half_day')}} </option>' +
                                '<option value="day_off"> {{__('administrator.day_off')}} </option>' +
                                '</select>';
                        }
                        day_amt += (i > 0 ? '<div class="col-sm-12 col-xs-12 blank5"></div>' : '') +
                            '<div class="col-sm-12 col-xs-12"><div class="col-sm-2">' +
                            '<input name="leavedate[]" type="text" class="form-control input-sm" readonly value="' + (date < 10 ? ('0' + date) : date) + '-' + (month < 10 ? ('0' + month) : month) + '-' + lday[i].getFullYear() + '">' +
                            '</div>' +
                            '<div class="col-sm-2">' +
                            '<input name="dayname[]" type="text" class="form-control input-sm" readonly value="' + weekday[day] + '">' +
                            '</div>' +
                            '<div class="col-sm-2">' +
                            $text +
                            '</div></div>';
                    }
                    $('.day_amt').html(day_amt);
                }, 500);
            }

            $(document).on('change', '.from_date', function () {
                find_day();
            });
            $(document).on('change', '.to_date', function () {
                find_day();
            });
        });
    </script>

@endsection

    

