@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="pull-left">
                            <h3>{{__('administrator.roles')}}</h3>
                        </div>
                        <div class="pull-right">
                            <a class=" button_info" href="{{route('hr-roles.create')}}"><span class="fa fa-plus"></span>  {{__('administrator.create_new')}}</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="wrapper-table">
                <table id="datatable_roles" class="table table-bordered table-hover nowrap customize">
                    <thead>
                    <tr>
                        <th>{{__('administrator.no')}}</th>
                        <th>{{__('administrator.role_name')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($data as $key=>$value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{$value->name}}</td>
                            <td>
                                <a class="button_primary" href="{{route('hr-roles.edit',$value->id)}}">{{__('administrator.edit')}}</a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
