@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.generate-salary.confirm-delete')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.generate-salary')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.generate-salary')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Salary Create'))
                                    <a class="btn btn-sm btn-success" href="{{route('hr-generate-salary.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatables" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.employee')}}</th>
                                        <th>{{__('administrator.month')}}</th>
                                        <th>{{__('administrator.year')}}</th>
                                        <th>{{__('administrator.basic_salary')}}</th>
                                        <th>{{__('administrator.advance_salary')}}</th>
                                        <th>{{__('administrator.take_leave')}}</th>
                                        <th>{{__('administrator.benefit')}}</th>
                                        <th>{{__('administrator.total_ot')}}</th>
                                        <th>{{__('administrator.net_pay_kh')}}</th>
                                        <th>{{__('administrator.net_pay')}}</th>
                                        <th>{{__('administrator.action')}}</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn-delete-gen', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatables').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: "{{ route('datatable.hr-gen-salary') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'emp_id'},
                        {data: 'f_month'},
                        {data: 'f_year'},
                        {data: 'basic_salary'},
                        {data: 'advance_salary'},
                        {data: 'take_leave'},
                        {data: 'benefit'},
                        {data: 'total_ot'},
                        {data: 'net_pay_kh'},
                        {data: 'net_pay'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
