@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.generate-salary.confirm-delete')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.generate_attendance')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.generate_attendance')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Generate Attendance Create'))
                                    <a class="btn btn-sm btn-success" href="{{route('hr-generate-attendance.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatables" width="100%" class="table table-striped">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{__('administrator.employee')}}</th>
                                    <th>{{__('administrator.att_date')}}</th>
                                    <th>{{__('administrator.cin')}}</th>
                                    <th>{{__('administrator.cout')}}</th>
                                    <th>{{__('administrator.otin')}}</th>
                                    <th>{{__('administrator.otout')}}</th>
                                    <th>{{__('administrator.total')}}</th>
                                    <th>{{__('administrator.late')}}</th>
                                    <th>{{__('administrator.before')}}</th>
                                    <th>{{__('administrator.ot')}}</th>
                                    <th>{{__('administrator.ot_type')}}</th>
                                    <th>{{__('administrator.missing')}}</th>
                                    <th>{{__('administrator.total_hol')}}</th>
                                    <th>{{__('administrator.total_sun')}}</th>
                                    <th>{{__('administrator.total_ot')}}</th>
                                    <th>{{__('administrator.action')}}</th>
                                </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatables').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "{{ route('hr-generate-attendance.index') }}",
                "scrollX": true,
                lengthMenu: [[20, 50, 100, 500, 100], [20, 50, 100, 500, 100]],
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'employee'},
                        {data: 'att_date'},
                        {data: 'cin'},
                        {data: 'cout'},
                        {data: 'otin'},
                        {data: 'otout'},
                        {data: 'total'},
                        {data: 'late'},
                        {data: 'before'},
                        {data: 'ot'},
                        {data: 'ot_type'},
                        {data: 'missing'},
                        {data: 'total_hol'},
                        {data: 'total_sun'},
                        {data: 'total_ot'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
