@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.exchange-rate.confirm-delete')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.exchange_rate")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.exchange_rate")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Exchange Rate Create'))
                                    <a class="btn btn-sm btn-success" href="{{route('hr-exchange-rate.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.general_rate')}}</th>
                                        <th>{{__('administrator.khmer_rate')}}</th>
                                        <th>{{__('administrator.thai_rate')}}</th>
                                        <th>{{__('administrator.date')}}</th>
                                        <th style="width: 200px;">{{__('administrator.action') }}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn_delete_exchange_rate', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{route('hr.get-exchange-rate')}}",
                columns:
                    [
                        {data: 'DT_RowIndex', orderable: false, searchable: false},
                        {data: 'general_rate'},
                        {data: 'khmer_rate'},
                        {data: 'thai_rate'},
                        {data: 'date'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {

                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
