@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.edit")}} {{__("administrator.exchange_rate")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.exchange_rate")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($rate, ['method' => 'PATCH','route' => ['hr-exchange-rate.update', $rate->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label class="required"  for="name">{{__('administrator.general_rate')}}</label>
                                            {!! Form::number('general_rate', null, array('placeholder' => __('administrator.general_rate'),'class' => 'form-control number-only','autocomplete'=>'off','required')) !!}
                                        
                                        </div>
                                        <div class="form-group">
                                                <label class="required"  for="name">{{__('administrator.khmer_rate')}}</label>
                                                {!! Form::number('khmer_rate', null, array('placeholder' => __('administrator.khmer_rate'),'class' => 'form-control number-only','autocomplete'=>'off','required')) !!}
                                            
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label class="required"  for="name">{{__('administrator.thai_rate')}}</label>
                                            {!! Form::number('thai_rate', null, array('placeholder' => __('administrator.thai_rate'),'class' => 'form-control number-only','step' => 'any','autocomplete'=>'off','required')) !!}
                                        
                                        </div>
                                        <div class="form-group">
                                                <label class="required"  for="name">{{__('administrator.date')}}</label>
                                                {!! Form::text('date', date('d-m-Y', strtotime($rate->date)), array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker','autocomplete'=>'off','required')) !!}
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection


    

