@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.Dashboard')}}</a></li>
            <li><a href="{{route('hr-dashboard.index')}}">{{__('administrator.company_structure')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.company_structure')}} </h3>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-right">
                            <a href="{{route('hr-company-structure.create')}}"
                               class="button_primary">{{__('administrator.add_new')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_products" width="100%" class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{ __('administrator.name') }}</th>
                    <th>{{__('administrator.type')}}</th>
                    <th>{{__('administrator.parent')}}</th>
                    <th>{{__('administrator.address')}}</th>
                    <th>{{ __('administrator.note') }}</th>
                    <th>{{ __('administrator.action') }}</th>
                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "{{ route('datatable.hr-get-company-structure') }}",
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'name'},
                        {data: 'type'},
                        {data: 'parent_id'},
                        {data: 'address'},
                        {data: 'note'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
