@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    <div class="title-add">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a class="ng-binding" href="#"><i class="fa fa-dashboard"></i> Dashboard</a> </li>
                <li> <a href="#">Manage HR</a> </li>
                <li> <a class="ng-binding" href="#">{{__('administrator.attendance')}}</a> </li>
            </ul>
        </div>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.attendance')}} </h3>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-right">
                            <a href="{{route('hr-attendance.create')}}"
                               class="button_primary">{{__('administrator.add_new')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_products" width="100%" class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{ __('administrator.employee')}}</th>
                    <th>{{__('administrator.time_in')}}</th>
                    <th>{{__('administrator.time_out')}}</th>
                    <th>{{ __('administrator.note')}}</th>
                    <th>{{ __('administrator.action')}}</th>
                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.viewPopLink', function () {
                var id = $(this).data('id');
                var url = "{{route('hr.overtime-change-status')}}";
                $('#form_update').attr('action', url + '?id=' + id);
                $('#myModal').modal('show');
            });
            $(document).on('click', '.viewot', function () {
                var id = $(this).data('id');
                $('#viewModal').modal('show');
                $.ajax({
                    url: "{{route('hr.overtime')}}",
                    type: 'GET',
                    data: {
                        "id": id,
                    },
                    success: function (data) {
                        $('.emp').text(data.datas.employee);
                        $('.project').text(data.datas.project);
                        $('.date').text(data.datas.dates);
                        $('.start').text(data.datas.starts);
                        $('.end').text(data.datas.ends);
                        $('.note').text(data.datas.note);
                        $('.status').html(data.datas.statuss);
                    }
                });
            });

            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "{{ route('datatable.hr-get-attendance') }}",
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'emp_id'},
                        {data: 'time_in'},
                        {data: 'time_out'},
                        {data: 'note'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
