@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.absent-policy.confirm-delete')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.absent_policy")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.absent_policy")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @can('Absent Policy Create')
                                    <a href="{{route('hr-absent-policy.create')}}" class="btn btn-sm btn-success"><span class="fa fa-plus"></span>{{__('administrator.add_new')}}</a>
                                @endcan
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.name') }}</th>
                                        <th>{{__('administrator.deduct_money') }}</th>
                                        <th>{{__('administrator.date') }}</th>
                                        <th>{{__('administrator.note')}}</th>
                                        <th style="width: 200px">{{ __('administrator.action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 75, 100, 1000], [20, 50, 75, 100, 1000]],
                ajax: "{{ route('hr-absent-policy.index') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', orderable: false, searchable: false},
                        {data: 'name'},
                        {data: 'deduct_money'},
                        {data: 'date'},
                        {data: 'note'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
