@extends('layouts.master')
<style>
  .canvasjs-chart-credit{
    display: none;
  }
</style>
  <!-- Content Wrapper. Contains page content -->
@section('content')
<style type="text/css">
  <link href="{{asset('assets/css/jquery-ui.1.11.2.min.css')}}" rel="stylesheet" />
</style>
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">{{__('application.Dashboard')}}</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">{{__("application.Home")}}</a></li>
              <li class="breadcrumb-item active">{{__('application.Dashboard')}}</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        @can('Dashboard-List')
        <div class="row">
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box" style="background-color: #ffc107;">
              <div class="inner">
                <h3>{{$Total_unavailable_items}}</h3>

                <p>Total Items Sold</p>
              </div>
              <div class="icon">
                <i class="fas fa-cart-arrow-down"></i>
              </div>
              <a href="{{route('item_sold_report.sold_item')}}" class="small-box-footer" style="color: white">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box" style="background-color: #F79F81">
                <div class="inner">
                    <h3>
                      {{!empty($Total_all_item_price)?number_format($Total_all_item_price,2):0}}
                    </h3>

                    <p>Total Project Sale($)</p>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
                <a href="{{route('item_report.all_item')}}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box" style="background-color: #F79F81">
                <div class="inner">
                    <h3>{{number_format($total_discount,2)}}</h3>

                    <p>Total Discount($)</p>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
                <a href="{{route('operation.payment')}}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box" style="background-color:#04B4AE">
                <div class="inner">
                    <h3>{{!empty($Total_sold_item_price)?number_format($Total_sold_item_price-$total_discount,2):0}}</h3>

                    <p>Total Sale Amount($)</p>
                </div>
                <div class="icon">
                    <i class="fas fa-cart-arrow-down"></i>
                </div>
                <a href="{{ route('operation.payment') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box" style="background-color:#79DB99">
              <div class="inner">
                <h3>{{empty($Total_colllection_payment->Total_owe_amount_pay)?0:number_format($Total_colllection_payment->Total_owe_amount_pay,2)}}</h3>

                <p>Total Collection($)</p>
              </div>
              <div class="icon">
                <i class="ion ion-pie-graph"></i>
              </div>
              <a href="{{ route('operation.collection') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-info">
              <div class="inner">
                <h3 style="color:black">
                  
                  {{number_format($Total_collected_priciple,2) }}
                </h3>

                <p style="color:black">Total Principle Collected($)</p>
              </div>
              <div class="icon">
                <i class="ion ion-bag"></i>
              </div>
              <a href="{{ route('operation.collected') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-info">
              <div class="inner">
                <h3 style="color:black">
                  {{number_format($Total_collected_interest,2) }}
                  
                </h3>

                <p style="color:black">Total Interest Collected($)</p>
              </div>
              <div class="icon">
                <i class="ion ion-bag"></i>
              </div>
              <a href="{{ route('operation.collected') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
              <div class="inner">
                <h3 style="color:black">{{number_format($Total_collected_penalty,2) }}</h3>

                <p style="color:black">Total Penalty Collected($)</p>
              </div>
              <div class="icon">
                <i class="ion ion-bag"></i>
              </div>
              <a href="{{ route('operation.collected') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
        </div>
        {{-- <div class="row">
          <!-- ./col -->
          <div class="col-lg-3 col-6">
              <!-- small box -->
              <div class="small-box" style="background-color: #58ACFA">
                  <div class="inner">
                      <h3 style="color:black">{{!empty($Total_deposit_item_price)?number_format($Total_deposit_item_price,2):0}}</h3>

                      <p style="color:black">Total Deposit Item Price($)</p>
                  </div>
                  <div class="icon">
                      <i class="fas fa-shopping-cart"></i>
                  </div>
                  <a href="{{ route('item_sold_report.sold_item') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
              </div>
          </div>
        </div> --}}
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">Payment Chart From <span style="color:#378DDB;">{{$first_date->format('d-m-Y')}}</span> To <span style="color:#378DDB;">{{$last_date->format('d-m-Y')}}</span></h3>

            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
              </button>
              <button disabled type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
              </button>
            </div>
          </div>
          <!-- /.card-header -->
          <div class="card-body">
            <div class="row">
              <div class="col-md-4">
                <div id="resizableCompleted" style="height: 370px;border:1px solid gray;">
                  <div id="chartContainerCompleted" style="height: 100%; width: 100%;"></div>
                </div>
              </div>
              <div class="col-md-4">
                <div id="resizableCollected" style="height: 370px;border:1px solid gray;">
                  <div id="chartContainerCollected" style="height: 100%; width: 100%;"></div>
                </div>
              </div>
              <div class="col-md-4">
                <div id="resizableCollection" style="height: 370px;border:1px solid gray;">
                  <div id="chartContainerCollection" style="height: 100%; width: 100%;"></div>
                </div>
              </div>
              <!-- /.col -->
            </div>
            <!-- /.row -->
          </div>
          <!-- /.footer -->
        </div>
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">Income Statement Chart (Cash Basic or Real Price) From <span style="color:#378DDB;">{{$first_date->format('d-m-Y')}}</span> To <span style="color:#378DDB;">{{$last_date->format('d-m-Y')}}</span> ( Total Income : {{$income}} $ ,Total Expense : {{$expense}} $ ,Net Income : {{$net_income}} $ )</h3>

            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
              </button>
              <button disabled type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
              </button>
            </div>
          </div>
          <!-- /.card-header -->
          <div class="card-body">
            <div class="row">
              <div class="col-md-6">
                <div id="Expense" style="height: 370px; width: 100%;"></div>
              </div>
              <div class="col-md-6">
                <div id="Income" style="height: 370px; width: 100%;"></div>
              </div>
              <!-- /.col -->
            </div>
            <!-- /.row -->
          </div>
          <!-- /.footer -->
        </div>
        @endcan
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
@endsection
@section("js")
<script src="{{asset('assets/js/jquery-1.11.1.min.js')}}"></script>
<script src="{{asset('assets/js/jquery-ui.1.11.2.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.canvasjs.min.js')}}"></script>
<script type="text/javascript">

  var income_data = {!!json_encode($data_income)!!};
  var expense_data = {!!json_encode($data_expense)!!};

  console.log(income_data);

  window.onload = function () {

    var Expense = {
      title: {
        text: "Expense"
      },
      data: [{
          type: "pie",
          startAngle: 45,
          showInLegend: "true",
          legendText: "{label}",
          indexLabel: "{label} ({y} $)",
          yValueFormatString:"#,##0.#"%"",
          dataPoints: expense_data
      }]
    };
    $("#Expense").CanvasJSChart(Expense);
    var Income = {
      title: {
        text: "Income"
      },
      data: [{
          type: "pie",
          startAngle: 45,
          showInLegend: "true",
          legendText: "{label}",
          indexLabel: "{label} ({y} $)",
          yValueFormatString:"#,##0.#"%"",
          dataPoints: income_data
      }]
    };
    $("#Income").CanvasJSChart(Income);
  // Construct options first and then pass it as a parameter
  var options_Completed = {
    animationEnabled: true,
    title: {
      text: "Sale Amount"
    },
    data: [{
      type: "column", //change it to line, area, bar, pie, etc
      legendText: "Amount",
      showInLegend: true,
      dataPoints: [
        { y:{{ $completed[0] }},x:1 },
        { y:{{ $completed[1] }},x:2},
        { y:{{ $completed[2] }},x:3},
        { y:{{ $completed[3] }},x:4},
        { y:{{ $completed[4] }},x:5},
        { y:{{ $completed[5] }},x:6},
        { y:{{ $completed[6] }},x:7},
        { y:{{ $completed[7] }},x:8},
        { y:{{ $completed[8] }},x:9},
        { y:{{ $completed[9] }},x:10},
        { y:{{ $completed[10] }},x:11},
        { y:{{ $completed[11] }},x:12}
        ]
      }]
  };

  $("#resizableCompleted").resizable({
    create: function (event, ui) {
      //Create chart.
      $("#chartContainerCompleted").CanvasJSChart(options_Completed);
    },
    resize: function (event, ui) {
      //Update chart size according to its container size.
      $("#chartContainerCompleted").CanvasJSChart().render();
    }
  });

  var optionsCollected = {
    animationEnabled: true,
    title: {
      text: "Payment Collected"
    },
    data: [{
      type: "column", //change it to line, area, bar, pie, etc
      legendText: "Amount",
      showInLegend: true,
      dataPoints: [
        { y:{{ $collected[0] }},x:1 },
        { y:{{ $collected[1] }},x:2},
        { y:{{ $collected[2] }},x:3},
        { y:{{ $collected[3] }},x:4},
        { y:{{ $collected[4] }},x:5},
        { y:{{ $collected[5] }},x:6},
        { y:{{ $collected[6] }},x:7},
        { y:{{ $collected[7] }},x:8},
        { y:{{ $collected[8] }},x:9},
        { y:{{ $collected[9] }},x:10},
        { y:{{ $collected[10] }},x:11},
        { y:{{ $collected[11] }},x:12}
        ]
      }]
  };


  $("#resizableCollected").resizable({
    create: function (event, ui) {
      //Create chart.
      $("#chartContainerCollected").CanvasJSChart(optionsCollected);
    },
    resize: function (event, ui) {
      //Update chart size according to its container size.
      $("#chartContainerCollected").CanvasJSChart().render();
    }
  });

  var optionsCollection = {
    animationEnabled: true,
    title: {
      text: "Payment Collection"
    },
    data: [{
      type: "column", //change it to line, area, bar, pie, etc
      legendText: "Amount",
      showInLegend: true,
      dataPoints: [
        { y:{{ $collection[0]}},x:1 },
        { y:{{ $collection[1]}},x:2},
        { y:{{ $collection[2]}},x:3},
        { y:{{ $collection[3]}},x:4},
        { y:{{ $collection[4]}},x:5},
        { y:{{ $collection[5]}},x:6},
        { y:{{ $collection[6]}},x:7},
        { y:{{ $collection[7]}},x:8},
        { y:{{ $collection[8]}},x:9},
        { y:{{ $collection[9]}},x:10},
        { y:{{ $collection[10]}},x:11},
        { y:{{ $collection[11]}},x:12}
        ]
      }]
  };
  $("#resizableCollection").resizable({
    create: function (event, ui) {
      //Create chart.
      $("#chartContainerCollection").CanvasJSChart(optionsCollection);
    },
    resize: function (event, ui) {
      //Update chart size according to its container size.
      $("#chartContainerCollection").CanvasJSChart().render();
    }
  });
}
</script>
@endsection
  <!-- /.content-wrapper -->
