@extends("layouts.master")
@section("content")
<style>
  div.dt-buttons{
    text-align: right;
    margin-bottom: 10px;
  }
  .dataTables_length{
    float: left;
  }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Cancel")}} {{__("application.Deposit")}}  </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.POS Operation")}}</li>
              <li class="breadcrumb-item active">{{__("application.Cancel")}} {{__("Deposit")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card" id="print-layout-nso">
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-deposit-cancellation" class="table table-bordered table-hover text-nowrap">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Date")}}</th>
                  <th>{{__("application.Date")}} {{__("application.Deposit")}}</th>
                  <th>{{__("application.Client")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Client")}} {{__("application.Phone")}}</th>
                  <th>{{__("application.Agency")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Item")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Category")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Project")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Date")}} {{__("application.Contract")}}</th>
                  <th>{{__("application.Amount")}} {{__("application.Sale")}}</th>
                  <th>{{__("application.Amount")}} {{__("application.Deposit")}}</th>
                  {{-- <th>Action</th> --}}
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datable-deposit-cancellation').DataTable({  
          "autoWidth": false,
          responsive: false, 
          ordering: false,
          serverSide: true,
          "scrollY": screen.height,
          "scrollX": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'cancellation-print',
                      onclick:"print(this)"
                  }
              },
          ],
          ajax: "{{ route('deposit-cancellation.get_index') }}",
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'updated_at','name':'nso007_sale_stock.updated_at'},
              {data: 'date','name':'nso007_sale_stock.date'},
              {data: 'client_name','name':'nso007_client.name'},
              {data: 'client_phone','name':'nso007_client.phone'},
              {data: 'agency_name','name':'nso007_agency.name'}, 
              {data: 'item_name','name':'nso007_item_stock.name'},  
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'project_name','name':'nso007_project_stock.name'},
              {data: 'date_on_contract','name':'nso007_sale_stock.date_on_contract'},
              {data: 'sale_amount','searchable': false},
              {data: 'sale_receive_amount','searchable': false},
              // {data: 'action','searchable': false}, 
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });
  function print(){
    var title=`Cancel Deposit Report`;
    var user_name = "{{Auth::user()->name}}";
    var date = "{{\Globals::date_khmers(date('d-m-Y'))}}";
    var table_data = $("#datable-deposit-cancellation").html();
    print_report(title,table_data,user_name,date);// Refference at master page
  }
</script>
@endsection