@extends("layouts.master")
@section("content")
@include('customer.add_feedback')
@include('customer.edit_add_feedback')
@include('customer.cofirm_delete')
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Customer Feedback List")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage Client")}}</li>
              <li class="breadcrumb-item"><a href="{{route('customer.index')}}">{{__("application.Customer")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Customer Feedback")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <input type="hidden" value="{{$customer_id}}" data-name="{{$customer_name}}" id="customer-id">
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <button class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                <button class="btn btn-sm btn-success" data-toggle="modal" data-target="#customer-add-feedback">{{__("application.Create New")}}</button>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-customer-feedback" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}} {{__("application.Follow Up")}}</th>
                  <th>{{__("application.Name")}} {{__("application.Customer")}}</th>
                  <th>{{__("application.Phone")}} {{__("application.Customer")}}</th>
                  <th>{{__("application.Date")}} {{__("application.Follow Up")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Status")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
    function delete_customer(id){
      $("#customer-feedback-id").val(id);
    }
    function edit(obj){
      $("#customer").val($(obj).attr("data-customer-id"));
      $("#customer-edit-feedback-name").val($(obj).data("customer-name"));
      $("#customer-edit-feedback-date").val($(obj).data("date"));
      $("#customer-edit-feedback-description").val($(obj).data("description"));
      $("#cus_feed").val($(obj).data("id"));
    }
    $(document).ready(function() {
       $("#customer_id").val($("#customer-id").val());
       $("#customer-add-feedback-name").val($("#customer-id").data("name"));
        $('.main-spinner').show();
        var route="{{ route('customer.get_feedback',":id") }}";
        route=route.replace(":id",$("#customer-id").val());
        $('#datable-customer-feedback').DataTable({  
            "autoWidth": false,
            ordering: false,
            serverSide: true,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
            ajax: route,
            columns: 
            [
                {data: 'DT_RowIndex','searchable': false},
                {data: 'customer_name','searchable': false}, 
                {data: 'customer_phone','searchable': false}, 
                {data: 'date','name':'nso007_customer_feedback.date'},
                {data: 'description','name':'nso007_customer_feedback.description'},   
                {data: 'action','searchable': false}, 
            ],

            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
</script>
@endsection