@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.List")}} {{__("application.Using")}} {{__("application.Detail")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Using")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-info btn-sm" onClick="javascript:history.go(-1)" style="color:white;"><span class="fa fa-reply"></span>  {{__('application.Back')}}</a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datatable-using" class="table table-bordered table-hover">
                <thead>
                  <tr>
                      <th>{{__('application.No')}}</th>
                      <th>{{__('application.Product')}} {{__('application.Name')}}</th>
                      <th>{{__('application.Category')}}</th>
                      <th>{{__('application.Unit')}} </th>
                      <th>{{__('application.Qty')}} {{__('application.Using')}}</th>
                      <th>{{__('application.Qty')}} {{__('application.Return')}}</th>
                      <th>{{__('application.Qty')}} {{__('application.In')}} {{__('application.Stock')}}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($usings_stock as $key=>$value)
                      <tr>
                          <td>{{$key+1}}</td>
                          <td>{{$value->pro_name}}</td>
                          <td>{{$value->pcat_name}}</td>
                          <td>{{$value->unit_name}}</td>
                          <td>{{($value->qty)-($value->return_qty)}}</td>
                          <td>{{$value->return_qty}}</td>
                          <td>{{$value->balance_qty}}</td>
                      </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>  
    $(document).ready(function() {
      $('#datatable-using').DataTable();
    });
</script>
@endsection