@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.List")}} {{__("application.Unit")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Unit")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{route('unit.create')}}"> {{__("application.Create New")}}</a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-category" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                  @foreach($data as $key=>$value)
                    <tr>
                        <td>{{$key+1}}</td>
                        <td>{{$value->unit_name}}</td>
                        <td>{{$value->unit_des}}</td>
                        <td>
                            <a href="#edit-form_{{$value->id}}" data-toggle="modal" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                        </td>
                    </tr>
                    <div class="modal fade" id="edit-form_{{$value->id}}">
                      <div class="modal-dialog modal-lg">
                        <form class="form-horizontal" role="form" action="{{route('unit.update')}}" method="post" name="cat">
                          @csrf
                        <div class="modal-content">
                          <div class="modal-header">
                            <h4 class="modal-title">Edit form</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          
                          <div class="modal-body">
                            <input type="hidden" name="unit_id" id="id" value="{{$value->id}}">
                            <div class="form-group">
                                <strong class="required">{{__("application.Unit")}} {{__("application.Name")}}:</strong>
                                <input type="text" name="unit_name" class="form-control  " id="name" value="{{$value->unit_name}}" placeholder='{{__("application.Unit")}} {{__("application.Name")}}' required="true">
                            </div>
                            <div class="form-group">
                                <strong>{{__("application.Description")}}:</strong>
                                {!! Form::textarea('unit_des', $value->unit_des, array('placeholder' => __('application.Description'),'class' => 'form-control','rows'=>3)) !!}
                            </div>
                          </div>
                          <div class="modal-footer justify-content-between">
                            <div>&nbsp;</div>
                            <button type="submit" class="btn btn-success btn-sm">{{__("application.Submit")}}</button>
                          </div>
                        </div>
                        </form>
                        <!-- /.modal-content -->
                      </div>
                      <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                  @endforeach
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>  
  $(document).ready(function  () {
    $("#datable-category").DataTable({
      "scrollY": screen.height,
      "scrollX": true,
    });
  });
</script>
@endsection