@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Account Type")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Accounting")}}</li>
              <li class="breadcrumb-item active">{{__("application.Account Type")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
                <table id="datatable_users" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>{{__('application.No')}}</th>
                            <th>{{__('application.Name')}} </th>
                            <th>{{__('application.Description')}}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($account_type as $key => $value )
                        <tr>

                            <td>{{$key+1}}</td>
                            <td>{{$value->acctype_name}}</td>
                            <td>{{$value->acctype_des}}</td>

                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection