@extends("layouts.master")
@section("content")
<div class="modal fade" id="view-receiveable-paid">
    <div class="modal-dialog modal-xl modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">{{__("application.A/R")}} {{__("application.Paid")}} {{__("application.List")}}</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="table-responsive">
            <table id="view-detail" class="table table-bordered table-condensed table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Date</th>
                        <th>Person</th>
                        <th>Account Name</th>
                        <th>Amount</th>
                        <th>Cash Type</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="tbody"></tbody>
                <tfoot id="tfoot">
                    <tr>
                        <td colspan="4" class="text-right bold-green">Total </td>
                        <td class="bold-orange" id="tf-paid-total"></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<div class="modal fade" id="input-date-print">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Date Print</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <input type="text" id="date-print" class="form-control date_picker" value="{{date('d-m-Y')}}">
      </div>
      <div class="modal-footer justify-content-between">
        <a>&nbsp;</a>
        <button type="button" id="btn-to-print" class="btn btn-primary">OK</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" style="/* min-height: 4390.14px; */">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.A/R")}} {{__("application.List")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Accounting")}}</li>
              <li class="breadcrumb-item active">{{__("application.A/R")}} {{__("application.List")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-header">
                <div class="row mb-2">
                    <div class="col-sm-12 col-xs-12">
                        {!! Form::open(array('route' => 'voucher.print','method'=>'POST','id'=>'print-voucher')) !!}
                        <input type="hidden" name="voucher" id="voucher">
                        <div class="title-bar">
                            <button type="submit" class="float-right btn btn-xs btn-warning" data-toggle="tooltip" data-placement="top" title="Print Voucher" disabled="disabled" style="display: none;"><i class="fa fa-print" aria-hidden="true"></i></button>
                            {{-- <span class="btn-toggle btn btn-primary btn-xs float-right" style="margin-right: 5px"><i class="fa fa-caret-down"></i></span> --}}
                        </div>
                        {!! Form::close() !!}
                        <div class="toggle-div" style="display: none">
                            <div class="form-group row">
                            
                                <div class="form-group  col-sm-6 col-xs-12">
                                    <label>Select Project</label>   
                                    {!! Form::select('journal_by_project[]', $projects, null, ['class' => 'form-control select2','id'=>'project_id','multiple']) !!}
                                </div>
                                <div class="col-sm-6 col-xs-12">
                                    <label>{{ __('application.last months') }}</label>
                                    {!! Form::select('last_months',\Globals::last_month_count(), null, ['placeholder'=>'Please Select','class' => 'form-control select2','id'=>'last_months']) !!}
                                </div>
                                <div class="col-sm-6 col-xs-12">
                                    <label for="">Start Date</label>
                                    <input type="text" class="form-control date_picker start_date">
                                </div>
                                <div class="col-sm-6 col-xs-12">
                                    <label for="">End Date</label>
                                    <input type="text" class="form-control date_picker end_date">
                                </div>
                                
                                <div class="col-sm-6 col-xs-12">
                                    <label for="">Account Name</label>
                                    {!! Form::select('journal_acccode[]',\Globals::get_account_code(1,0), null, ['class' => 'form-control select2','id'=>'journal_acccode','multiple']) !!}
                                </div>
                                <div class="col-sm-6 col-xs-12">
                                    <label for="">Voucher Number</label>
                                    <input type="voucher_ref" class="form-control" id="voucher_ref">
                                </div>
                                <div class="col-xs-12 col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <strong>{{__('application.Supplier')}}</strong> {!! Form::select('supps_id[]', $supps, null, ['class' => 'form-control select2 supps_id','multiple']) !!}
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <strong>{{__('application.Description')}}</strong> 
                                        <textarea type="text" name="description" class="form-control description" rows="2"></textarea>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-xs-12" style="text-align: right">
                                    <button type="button" style="margin-top: 30px;" class="btn btn-warning" onclick="search_journal()"> Search <span class="fa fa-search"></span></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            @can('Add-Account-Receiveable')
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{route('account_receiveable.create')}}"> {{__("application.Create New")}}</a>
              </div>
            @endcan
            </div>
            <div class="card-body table-responsive">
                <table id="table_journal" class="table table-bordered table table-condensed table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th style="width:10%">Date</th>
                            {{-- <th>Project Name</th> --}}
                            {{-- <th>Voucher Type</th> --}}
                            <th>Voucher Number</th>
                            <th>Account Name</th>
                            <th>Supplier</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>Paid Amount</th>
                            <th>Balance</th>
                            <th class="hidden-print" style="width:10%">Action</th>
                        </tr>
                    </thead>
                    <tbody id="tbody"></tbody>
                    <tfoot id="tfoot">
                        <tr>
                            <td colspan="6" class="text-right bold-green">Total </td>
                            <td class="bold-orange"></td>
                            <td class="bold-orange"></td>
                            <td class="bold-orange"></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dm">
        <div class="modal-content">
            <div class="modal-header">
                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
                <h3 class="modal-title text-danger">Warning...!</h3>
            </div>
            <br />
            <div class="row">
                <div class="col-md-12">
                    <div class="col-md-10">
                        <h4>Receivable amount must be smaller than or equal available amount.</h4>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="button_primary"><i class="fa fa-close"></i> Close</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
@endsection
@section('js')
<script>
    function view_get_paid(receiveable_id){
        let route = "{{ route('account_receiveable.get_view_paid',':id') }}";
        route = route.replace(":id",receiveable_id);
        $.ajax({
            url:route,
            type:"GET",
            dataType:"JSON",
            success:function(data){
                var tbody = ``;let total_amount = 0;
                $.each(data,function(index,value){
                    total_amount += Number(value.journal_debit);
                    let route_print = "{{ route('account_receiveable.print_invoice',':id') }}";
                    route_print = route_print.replace(":id",value.id);
                    tbody += `<tr>
                                <td>${index+1}</td>
                                <td>${value.paid_date}</td>
                                <td>${value.person_name==null?'':value.person_name}</td>
                                <td>${value.acc_name}</td>
                                <td>${"$"+value.journal_debit.toFixed(2)}</td>
                                <td>${value.journal_acccode=="11001"?"Cash On Hand":"Cash In Bank"}</td>
                                <td><a href='${route_print}' target='_blank' class='btn btn-sm btn-primary' title='Print'>
                                    <i class='fas fa-print'></i>
                                </a> <a href="javascript:void(0)" onclick = "receiveable_delete(${value.id})" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a></td>
                            </tr>`;
                });
                $("#view-receiveable-paid").modal("show");
                $("#view-detail").find("tbody").html(tbody);
                $("#tf-paid-total").text("$"+total_amount.toFixed(2));
            },
            error:function(){

            }
        });
    }
    function receiveable_delete(journal_id){
        var id = journal_id;
        $.confirm({
            title:'Are you sure ?',
            content:'',
            theme:'modern',
            buttons:{
                cancel:{
                    btnClass:'btn btn-primary',
                    text:'Cancel',
                    action:function () {

                    }
                },
                submit:{
                    btnClass:'btn btn-danger',
                    text:"Delete",
                    action:function () {
                            window.location.replace('{{route("account_receiveable.paid_delete")}}?id='+id);
                    }
                },
            },
        });
    }
    function delete_account_receiveable(journal_id)
    {
        var id = journal_id;
        $.confirm({
            title:'Are you sure ?',
            content:'',
            theme:'modern',
            buttons:{
                cancel:{
                    btnClass:'btn btn-primary',
                    text:'Cancel',
                    action:function () {

                    }
                },
                submit:{
                    btnClass:'btn btn-danger',
                    text:"Delete",
                    action:function () {
                            window.location.replace('{{route("account_receiveable.delete")}}?id='+id);
                    }
                },
            },
        });
    }
    $(document).ready(function() {
        $('#table_journal').DataTable({
            "ordering":true,
            "searching" :false,
            "serverSide":true,
            responsive:false,
            "lengthMenu": [
                [20, 50, 100, 250, 500,1000],
                [20, 50, 100, 250, 500,100]
            ],
            dom: 'Blfrtip',
            buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              },
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'print-report-id',
                      onclick:"print(this)"
                  }
              },
          ],
            ajax: {
                url:"{{ route('account_receiveable.index') }}",
                type:"GET",
                data:function(d){
                    d.project_id = $("#project_id").val();
                    d.start_date = $(".start_date").val();
                    d.end_date = $(".end_date").val();
                    d.last_months = $("#last_months").val();
                    d.journal_acccode = $("#journal_acccode").val();
                    d.voucher_ref = $("#voucher_ref").val();
                    d.description = $(".description").val();
                    d.supps_id = $(".supps_id").val();
                }
            },
            columns: [
                { data: 'DT_RowIndex',  orderable: false, searchable: false},
                {
                    data: 'journal_paydate',
                },
                // {
                //     data: 'project_name'
                // },
                // {
                //     data: 'voucher'
                // },
                {
                    data: 'voucher_ref'
                },
                {
                    data: 'account_code'
                },
                {
                    data: 'supp_name'
                },
                {
                    data: 'journal_des'
                },
                {
                    data: 'journal_debit'
                },
                {
                    data: 'receiveable_paid'
                },
                {
                    data: 'balance'
                },
                {
                    data: 'action','className':'hidden-print'
                },
            ],
            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            },
            "footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;

                // converting to interger to find total
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };
                var Total_paid_Received = api
                    .column( 6 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                var balance = api
                    .column( 7 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                    var balance8 = api
                    .column( 8 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                var currentcyFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$' ).display;
                $( api.column( 6 ).footer() ).html(currentcyFormat(Total_paid_Received));
                $( api.column( 7 ).footer() ).html(currentcyFormat(balance));
                $( api.column( 8 ).footer() ).html(currentcyFormat(balance8));

            },
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
</script>
<script type="text/javascript">

    $(document).ready(function () {
        $('#journal-del').on('click',function (e) {
            e.preventDefault();
            var id = $('#delete-id').val();
            $.ajax({
                url:"{{route('journal_confirm_delete')}}",
                type:"POST",
                dataType:"JSON",
                data:{
                    "_token": "{{ csrf_token() }}",
                    "delete_id" : id
                },
                success:function (data) {
                    $('#form-delete').modal('hide');
                    $('#table_journal').DataTable().ajax.reload();
                    toastr['success'](data['message']);
                },
                error:function (err) {
                    console.log(err);
                }
            });
        });
    });
    function search_report(obj){
        $('.toggle-div').toggle('fast');
    }
    var ArrId = [];
    
    
    $(document).on('click', '.btn-action', function() {
        $('#block-action').toggle("fast");
    });


    $("form").submit(function(e) {
        if (ArrId === undefined || ArrId.length == 0) {
            $.alert({
                title: 'Error',
                icon: 'fa fa-warning',
                type: 'orange',
                content: 'No fileds Selected' +
                    '<hr>' +
                    'Please Select Any Fields',
            });
            return false;
        }
    });

    function push_data(obj) {
        $('#voucher').val(obj);
    }

    function push_array(obj) {
        obj = [];
        $('.checkbox').each(function() {
            var id = $(this).attr('id');
            obj.push(id);
        });
        return obj;
    }

    function search_journal() {
        $('#table_journal').DataTable().draw(true);
    }
    function print(){
        var title=`Report Account Receiveable`;
        var user_name = "{{Auth::user()->name}}";
        var date = "{{\Globals::date_khmers(date('d-m-Y'))}}";
        var table_data = $("#table_journal").html();
        var project_name = "";
        let i = 0;
        $("select#project_id option").each(function(index,value){
        if($(this).prop("selected")==true){
            i++;
            project_name += $(this).text();
            if(i<$("#project_id option:selected").length) project_name += " និង ";
        }
        });
        let p_name = '';
        if(project_name!=''){
        p_name = '( គម្រោង៖ '+project_name+' )';
        }
        print_report_operation(title,table_data,user_name,date,p_name);// Refference at master page
    }
</script>
@endsection
