@extends("layouts.master")
@section("content")
@include('accounting.account-chart.confirm-delete')
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" style="/* min-height: 4390.14px; */">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Account Chart")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Account Chart")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            @can('Account-Chart-Create')
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{route('account-chart.create')}}"> {{__("application.Create New")}}</a>
              </div>
            </div>
            @endcan
            <div class="card-body">
                <table id="datatable_account_chart" class="table table-bordered table-hover nowrap">
                    <thead>
                        <tr>
                            <th>{{__('application.Account')}} {{__("application.Code")}}</th>
                            <th>{{__('application.Account')}} {{__("application.Name")}}</th>
                            <th>{{__("application.Account")}} {{__('application.Name Khmer')}}</th>
                            <th>{{__('application.Type')}}</th>
                            <th>{{__('application.Description')}}</th>
                            <th>{{__('application.Action')}}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($account_chart) && count($account_chart) > 0)
                            @foreach($account_chart as $key => $acc_chart)
                                <tr id="{{$acc_chart->id}}">
                                    <td>{{$acc_chart->id}}</td>
                                    <td>{{$acc_chart->acc_name}}</td>
                                    <td>{{$acc_chart->acc_namekh}}</td>
                                    <td>{{$acc_chart->acctype_name}}</td>
                                    <td>{{$acc_chart->acc_des}}</td>
                                    <td>@if($acc_chart->acc_status != 0)
                                            @can('Account-Chart-Edit')
                                            <a href="{{route('account-chart.edit',$acc_chart->id)}}" class="btn btn-success btn-sm"><i class="fa fa-edit" title="Edit"> </i> </a>
                                            @endcan
                                            &nbsp;
                                            @can('Account-Chart-Delete')
                                            <a href="#" data-id = "{{$acc_chart->id}}" data-toggle="modal" data-target="#form-delete" class="btn-sm btn btn-danger confirm_delete" data-toggle="tooltip" data-placement="top" title="Delete"><i class="fa fa-trash"></i></a>
                                            @endcan
                                        @else
                                            @can('Account-Chart-Edit')
                                            <button disabled class="btn btn-success btn-sm"><i class="fa fa-edit" title="Edit"></i></button>
                                            @endcan
                                            &nbsp;
                                            @can('Account-Chart-Delete')
                                            <button class="btn-sm btn btn-danger" disabled title="Delete"><i class="fa fa-trash"></i></button>
                                            @endcan
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript">
    $(document).ready(function() {
        $('#datatable_account_chart').DataTable({
            ordering:false,
            info:false,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
        });
        $(document).on('click','.confirm_delete',function(){
            var id = $(this).data('id');
            $('#delete-id').val(id);
            $('#form-delete').modal('show');
        });

        $('#form-delete-acc').on('submit',function (e) {
            var id = $('#delete-id').val();
            e.preventDefault();
            $.ajax({
                url:"{{route('account-chart.delete')}}",
                type:"POST",
                dataType:"JSON",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "delete_id": id
                },
                success:function (data) {
                    window.location.reload();
                    $('#form-delete').modal('hide');
                    $('#datatable_account_chart').DataTable().ajax.reload();
                    toastr['success'](data['message']);
                },
                error:function (err) {
                    console.log(err);
                }
            });
        });
    });
</script>
@endsection