<?php

namespace App\Models\Hr;

use Illuminate\Database\Eloquent\Model;

class HrEmployeeRotateModel extends Model
{
    protected $table = "users_rotate";

    protected $casts = [
        'educate' => 'array',
        'language' => 'array',
        'emergency_contact' => 'array',
        'family' => 'array',
        'family_full' => 'array',
        'work_experience' => 'array'
    ];

    public function group()
    {
        return $this->belongsTo('App\UserGroupModel','group_id','id');
    }
    public function from_branch()
    {
        return $this->belongsTo('App\Models\Hr\HrBranch','current_branch_id', 'id');
    }
    public function from_department()
    {
        return $this->belongsTo('App\Models\Hr\HrDepartmentModel','current_department_id','id');
    }
    public function from_position()
    {
        return $this->belongsTo('App\Models\Hr\HrPositionModel','current_position_id','id');
    }


    public function to_branch()
    {
        return $this->belongsTo('App\Models\Hr\HrBranch','transfer_branch_id', 'id');
    }

    public function to_department()
    {
        return $this->belongsTo('App\Models\Hr\HrDepartmentModel','transfer_department_id','id');
    }

    public function to_position()
    {
        return $this->belongsTo('App\Models\Hr\HrPositionModel','transfer_position_id','id');
    }

    public function employment()
    {
        return $this->belongsTo('App\HrEmploymentStatusModel','employment_id','id');
    }
}
