<?php

namespace App\Models\Hr;

use Illuminate\Database\Eloquent\Model;

class DevelopmentPlanModel extends Model
{
    protected $table = "nso007_hr_development_plan";

    protected $fillable = [
        'suggestion_training','suggestion_hard_skill','suggestion_soft_skill'
    ];
    protected $casts = [
        'suggestion_training' => 'array',
        'suggestion_hard_skill' => 'array',
        'suggestion_soft_skill' => 'array'
    ];

    public function get_employee(){
        return $this->belongsTo('App\User','emp_id','id');
    }
    public function get_request_to(){
        return $this->belongsTo('App\User','request_to','id');
    }
}
