<?php

namespace App\Models;

use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class EmployeeLeaveTotal extends Model
{

    /*
    |--------------------------------------------------------------------------
    | GLOBAL VARIABLES
    |--------------------------------------------------------------------------
    */

    protected $table = 'emp_leave_total';
    protected $primaryKey = 'id';
    // public $timestamps = false;
    // protected $guarded = ['id'];
    protected $fillable = ['emp_id', 'leave_year', 'special_leave', 'sick_leave', 'maternity_leave', 'annual_leave', 'unpaid_leave', 'other_leave'];
    // protected $hidden = [];
    // protected $dates = [];

    /*
    |--------------------------------------------------------------------------
    | FUNCTIONS
    |--------------------------------------------------------------------------
    */
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'emp_id');
    }

    function leaveDetail()
    {
        return $this->hasOne(EmployeeLeaveTotalDetail::class, 'emp_leave_total_id');
    }
    /*
    |--------------------------------------------------------------------------
    | RELATIONS
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | SCOPES
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | ACCESORS
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | MUTATORS
    |--------------------------------------------------------------------------
    */
    public static function getEmployeeLeaveTotal($emp_id = null, $from_date = null, $to_date = null, $leave_type_name = null, $leave_type_id = null)
    {
        if ($emp_id != null && $from_date != null && $to_date != null && $leave_type_id != null) {
            $from_date_y = Carbon::parse($from_date)->format('Y');
            $to_date_y = Carbon::parse($to_date)->format('Y');
            $leave_type = LeaveType::getLeaveTypeName($leave_type_id);
            $leave_type = (string)$leave_type;
            $is_emp_id = is_array($emp_id);
            switch ($is_emp_id) {
                case true:
                    return optional(self::where(function ($q) use ($emp_id, $from_date_y, $to_date_y) {
                        if (count($emp_id)) {
                            $q->whereIn('emp_id', $emp_id)->where('leave_year', '>=', $from_date_y)->where('leave_year', '<=', $to_date_y);
                        }
                    })->first())->$leave_type;
                    break;
                case false:
                    return optional(self::where(function ($q) use ($emp_id, $from_date_y, $to_date_y) {
                        $q->where('emp_id', $emp_id)->where('leave_year', '>=', $from_date_y)->where('leave_year', '<=', $to_date_y);
                    })->first())->$leave_type;
                    break;
            }
        } elseif ($emp_id != null && $from_date != null && $to_date != null && $leave_type_name != null) {
            $from_date_y = Carbon::parse($from_date)->format('Y');
            $to_date_y = Carbon::parse($to_date)->format('Y');
            $leave_type_name = (string)$leave_type_name;
            $is_emp_id = is_array($emp_id);
            switch ($is_emp_id) {
                case true:
                    return optional(self::where(function ($q) use ($emp_id, $from_date_y, $to_date_y) {
                        if (count($emp_id)) {
                            $q->whereIn('emp_id', $emp_id)->where('leave_year', '>=', $from_date_y)->where('leave_year', '<=', $to_date_y);
                        }
                    })->first())->$leave_type_name;
                    break;
                case false:
                    return optional(self::where(function ($q) use ($emp_id, $from_date_y, $to_date_y) {
                        $q->where('emp_id', $emp_id)->where('leave_year', '>=', $from_date_y)->where('leave_year', '<=', $to_date_y);
                    })->first())->$leave_type_name;
                    break;
            }
        }
        return self::where('leave_year', Carbon::now()->format('Y'))->get();
    }
}
